/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.mkv;

import com.amazonaws.kinesisvideo.parser.ebml.EBMLElementMetaData;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitException;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.apache.commons.lang3.Validate;

public abstract class MkvElement {
    protected static final int MAX_ID_AND_SIZE_BYTES = 12;
    protected final EBMLElementMetaData elementMetaData;
    protected final List<EBMLElementMetaData> elementPath;

    protected boolean typeEquals(MkvElement other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        return this.elementMetaData.getTypeInfo().equals(other.getElementMetaData().getTypeInfo());
    }

    public abstract boolean isMaster();

    public abstract void accept(MkvElementVisitor var1) throws MkvElementVisitException;

    public abstract boolean equivalent(MkvElement var1);

    public void writeToChannel(WritableByteChannel outputChannel) throws MkvElementVisitException {
    }

    protected void writeByteBufferToChannel(ByteBuffer src, WritableByteChannel outputChannel) throws MkvElementVisitException {
        src.rewind();
        int size = src.remaining();
        try {
            int numBytes = outputChannel.write(src);
            Validate.isTrue((size == numBytes ? 1 : 0) != 0, (String)("Output channel wrote " + size + " bytes instead of " + numBytes), (Object[])new Object[0]);
        }
        catch (IOException e) {
            throw new MkvElementVisitException("Writing to output channel failed", e);
        }
        finally {
            src.rewind();
        }
    }

    public EBMLElementMetaData getElementMetaData() {
        return this.elementMetaData;
    }

    public List<EBMLElementMetaData> getElementPath() {
        return this.elementPath;
    }

    public String toString() {
        return "MkvElement(elementMetaData=" + this.getElementMetaData() + ", elementPath=" + this.getElementPath() + ")";
    }

    MkvElement(EBMLElementMetaData elementMetaData, List<EBMLElementMetaData> elementPath) {
        this.elementMetaData = elementMetaData;
        this.elementPath = elementPath;
    }
}

