/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.mkv;

import com.amazonaws.kinesisvideo.parser.ebml.EBMLElementMetaData;
import com.amazonaws.kinesisvideo.parser.ebml.EBMLParserCallbacks;
import com.amazonaws.kinesisvideo.parser.ebml.EBMLTypeInfo;
import com.amazonaws.kinesisvideo.parser.ebml.ParserBulkByteSource;
import com.amazonaws.kinesisvideo.parser.mkv.MkvDataElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvEndMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvStartMasterElement;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Predicate;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MkvStreamReaderCallback
implements EBMLParserCallbacks {
    private static final Logger log = LoggerFactory.getLogger(MkvStreamReaderCallback.class);
    private Optional<CurrentMkvDataElementInfo> currentMkvDataElementInfo = Optional.empty();
    private final Queue<MkvElement> elementsToReturn = new ArrayDeque<MkvElement>();
    private final boolean shouldStoreElementPaths;
    private final Predicate<EBMLTypeInfo> elementFilter;
    private static final int MAX_BUFFER_SIZE = 1000000;
    ByteBuffer readBuffer = ByteBuffer.allocate(1000000);

    @Override
    public void onStartElement(EBMLElementMetaData elementMetaData, long elementDataSize, ByteBuffer idAndSizeRawBytes, EBMLParserCallbacks.ElementPathSupplier pathSupplier) {
        Validate.isTrue((!this.currentMkvDataElementInfo.isPresent() ? 1 : 0) != 0);
        if (elementMetaData.isMaster()) {
            log.debug("Start Master Element to return {} data size {} ", (Object)elementMetaData, (Object)elementDataSize);
            this.addMkvElementToReturn(MkvStartMasterElement.builder().elementMetaData(elementMetaData).elementPath(this.getPath(pathSupplier)).dataSize(elementDataSize).idAndSizeRawBytes(idAndSizeRawBytes).build());
        } else {
            if (elementDataSize > (long)this.readBuffer.capacity()) {
                int sizeToAllocate = (int)Math.ceil((double)elementDataSize / 1000000.0) * 1000000;
                log.debug("Resizing readBuffer to {}", (Object)sizeToAllocate);
                this.readBuffer = ByteBuffer.allocate(sizeToAllocate);
            }
            this.readBuffer.clear();
            if (this.elementFilter.test(elementMetaData.getTypeInfo())) {
                log.debug("Data Element to start building {} data size {} ", (Object)elementMetaData, (Object)elementDataSize);
                List<EBMLElementMetaData> elementPath = this.getPath(pathSupplier);
                this.currentMkvDataElementInfo = Optional.of(new CurrentMkvDataElementInfo(elementMetaData, elementDataSize, elementPath, idAndSizeRawBytes));
            }
        }
    }

    private List<EBMLElementMetaData> getPath(EBMLParserCallbacks.ElementPathSupplier pathSupplier) {
        List<EBMLElementMetaData> elementPath = this.shouldStoreElementPaths ? pathSupplier.getAncestors() : new ArrayList<EBMLElementMetaData>();
        return elementPath;
    }

    @Override
    public void onPartialContent(EBMLElementMetaData elementMetaData, ParserBulkByteSource bulkByteSource, int bytesToRead) {
        Validate.isTrue((boolean)this.elementsToReturn.isEmpty());
        if (this.elementFilter.test(elementMetaData.getTypeInfo())) {
            Validate.isTrue((boolean)this.currentMkvDataElementInfo.isPresent());
            this.currentMkvDataElementInfo.get().validateExpectedElement(elementMetaData);
            log.debug("Data Element to start buffering data {} bytes to read {} ", (Object)elementMetaData, (Object)bytesToRead);
        }
        if (!elementMetaData.isMaster()) {
            bulkByteSource.readBytes(this.readBuffer, bytesToRead);
        }
    }

    @Override
    public void onEndElement(EBMLElementMetaData elementMetaData, EBMLParserCallbacks.ElementPathSupplier pathSupplier) {
        if (elementMetaData.isMaster()) {
            Validate.isTrue((!this.currentMkvDataElementInfo.isPresent() ? 1 : 0) != 0);
            log.debug("End Master Element to return {}", (Object)elementMetaData);
            this.addMkvElementToReturn(MkvEndMasterElement.builder().elementMetaData(elementMetaData).elementPath(this.getPath(pathSupplier)).build());
        } else if (this.elementFilter.test(elementMetaData.getTypeInfo())) {
            Validate.isTrue((boolean)this.currentMkvDataElementInfo.isPresent());
            log.debug("Data Element to return {} data size {} ", (Object)elementMetaData, (Object)this.readBuffer.position());
            this.readBuffer.flip();
            this.addMkvElementToReturn(this.currentMkvDataElementInfo.get().build(this.readBuffer));
            this.currentMkvDataElementInfo = Optional.empty();
        }
    }

    @Override
    public boolean continueParsing() {
        return this.elementsToReturn.isEmpty();
    }

    boolean hasElementsToReturn() {
        return !this.elementsToReturn.isEmpty();
    }

    public Optional<MkvElement> getMkvElementIfAvailable() {
        if (this.elementsToReturn.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.elementsToReturn.remove());
    }

    private void addMkvElementToReturn(MkvElement elementToReturn) {
        this.elementsToReturn.add(elementToReturn);
    }

    public MkvStreamReaderCallback(boolean shouldStoreElementPaths, Predicate<EBMLTypeInfo> elementFilter) {
        this.shouldStoreElementPaths = shouldStoreElementPaths;
        this.elementFilter = elementFilter;
    }

    private static class CurrentMkvDataElementInfo {
        private final EBMLElementMetaData elementMetadata;
        private final long dataSize;
        private final List<EBMLElementMetaData> elementPath;
        private final ByteBuffer idAndSizeRawBytes = ByteBuffer.allocate(12);

        CurrentMkvDataElementInfo(EBMLElementMetaData elementMetadata, long dataSize, List<EBMLElementMetaData> elementPath, ByteBuffer idAndSizeRawBytes) {
            this.elementMetadata = elementMetadata;
            this.dataSize = dataSize;
            this.elementPath = elementPath;
            this.idAndSizeRawBytes.put(idAndSizeRawBytes);
            this.idAndSizeRawBytes.flip();
            idAndSizeRawBytes.rewind();
        }

        MkvDataElement build(ByteBuffer data) {
            Validate.isTrue(((long)data.limit() == this.dataSize ? 1 : 0) != 0);
            return MkvDataElement.builder().elementMetaData(this.elementMetadata).dataSize(this.dataSize).idAndSizeRawBytes(this.idAndSizeRawBytes).elementPath(this.elementPath).dataBuffer(data).build();
        }

        public void validateExpectedElement(EBMLElementMetaData elementMetaData) {
            Validate.isTrue((boolean)elementMetaData.equals(this.elementMetadata));
        }
    }
}

