/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.mkv;

import com.amazonaws.kinesisvideo.parser.ebml.EBMLTypeInfo;
import com.amazonaws.kinesisvideo.parser.ebml.EBMLTypeInfoProvider;
import com.amazonaws.kinesisvideo.parser.ebml.MkvTypeInfos;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class MkvTypeInfoProvider
implements EBMLTypeInfoProvider {
    private final Map<Integer, EBMLTypeInfo> typeInfoMap = new HashMap<Integer, EBMLTypeInfo>();

    public void load() throws IllegalAccessException {
        for (Field field : MkvTypeInfos.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(EBMLTypeInfo.class)) continue;
            EBMLTypeInfo type = (EBMLTypeInfo)field.get(null);
            Validate.isTrue((!this.typeInfoMap.containsKey(type.getId()) ? 1 : 0) != 0);
            this.typeInfoMap.put(type.getId(), type);
        }
    }

    @Override
    public Optional<EBMLTypeInfo> getType(int id) {
        return Optional.ofNullable(this.typeInfoMap.get(id));
    }
}

