/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.mkv;

import java.nio.ByteBuffer;
import lombok.NonNull;

public class MkvValue<T> {
    @NonNull
    private final T val;
    private final long originalDataSize;

    public T getVal() {
        if (ByteBuffer.class.isAssignableFrom(this.val.getClass())) {
            ByteBuffer byteBufferVal = (ByteBuffer)this.val;
            byteBufferVal.rewind();
        }
        return this.val;
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (!otherObj.getClass().equals(this.getClass())) {
            return false;
        }
        MkvValue other = (MkvValue)otherObj;
        if (!this.val.getClass().equals(other.val.getClass())) {
            return false;
        }
        if (this.originalDataSize != other.originalDataSize) {
            return false;
        }
        return this.getVal().equals(other.getVal());
    }

    public int hashCode() {
        int result = this.val.hashCode();
        result = 31 * result + (int)(this.originalDataSize ^ this.originalDataSize >>> 32);
        return result;
    }

    public MkvValue(@NonNull T val, long originalDataSize) {
        if (val == null) {
            throw new NullPointerException("val is marked non-null but is null");
        }
        this.val = val;
        this.originalDataSize = originalDataSize;
    }

    public long getOriginalDataSize() {
        return this.originalDataSize;
    }
}

