/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.mkv;

import com.amazonaws.kinesisvideo.parser.ebml.EBMLParser;
import com.amazonaws.kinesisvideo.parser.ebml.EBMLTypeInfo;
import com.amazonaws.kinesisvideo.parser.ebml.ParserByteSource;
import com.amazonaws.kinesisvideo.parser.mkv.MkvDataElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitException;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.MkvStreamReaderCallback;
import com.amazonaws.kinesisvideo.parser.mkv.MkvTypeInfoProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingMkvReader {
    private static final Logger log = LoggerFactory.getLogger(StreamingMkvReader.class);
    private final boolean requirePath;
    private final Set<EBMLTypeInfo> typeInfosToRead;
    private final ParserByteSource byteSource;
    private final EBMLParser parser;
    private final MkvStreamReaderCallback mkvStreamReaderCallback;
    private Optional<MkvDataElement> previousDataElement;

    StreamingMkvReader(boolean requirePath, Collection<EBMLTypeInfo> typeInfosToRead, ParserByteSource byteSource) {
        this(requirePath, typeInfosToRead, byteSource, OptionalInt.empty());
    }

    StreamingMkvReader(boolean requirePath, Collection<EBMLTypeInfo> typeInfosToRead, ParserByteSource byteSource, OptionalInt maxContentBytesAtOnce) {
        this.requirePath = requirePath;
        typeInfosToRead.stream().forEach(t -> Validate.isTrue((t.getType() != EBMLTypeInfo.TYPE.MASTER ? 1 : 0) != 0));
        this.typeInfosToRead = new HashSet<EBMLTypeInfo>(typeInfosToRead);
        this.byteSource = byteSource;
        this.mkvStreamReaderCallback = new MkvStreamReaderCallback(this.requirePath, this.elementFilter());
        this.previousDataElement = Optional.empty();
        MkvTypeInfoProvider typeInfoProvider = new MkvTypeInfoProvider();
        try {
            typeInfoProvider.load();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not load mkv info", e);
        }
        this.parser = maxContentBytesAtOnce.isPresent() ? new EBMLParser(typeInfoProvider, this.mkvStreamReaderCallback, maxContentBytesAtOnce.getAsInt()) : new EBMLParser(typeInfoProvider, this.mkvStreamReaderCallback);
    }

    public static StreamingMkvReader createDefault(ParserByteSource byteSource) {
        return new StreamingMkvReader(true, new ArrayList<EBMLTypeInfo>(), byteSource, OptionalInt.empty());
    }

    public static StreamingMkvReader createWithMaxContentSize(ParserByteSource byteSource, int maxContentBytesAtOnce) {
        return new StreamingMkvReader(true, new ArrayList<EBMLTypeInfo>(), byteSource, OptionalInt.of(maxContentBytesAtOnce));
    }

    public boolean mightHaveNext() {
        if (this.mkvStreamReaderCallback.hasElementsToReturn()) {
            log.debug("ReaderCallback has elements to return ");
            return true;
        }
        if (!this.byteSource.eof() && !this.parser.isClosed()) {
            return true;
        }
        if (this.byteSource.eof()) {
            log.debug("byteSource has reached eof");
            if (!this.parser.isClosed()) {
                log.debug("byteSource has reached eof and calling close on parser");
                this.parser.closeParser();
                return true;
            }
        }
        log.debug("No more elements to process byteSource.eof {} parser.isClosed {} ", (Object)this.byteSource.eof(), (Object)this.parser.isClosed());
        return false;
    }

    public Optional<MkvElement> nextIfAvailable() {
        if (this.mkvStreamReaderCallback.hasElementsToReturn()) {
            if (log.isDebugEnabled()) {
                log.debug("ReaderCallback has elements to return. Return element from it.");
            }
            return this.getMkvElementToReturn();
        }
        this.parser.parse(this.byteSource);
        return this.getMkvElementToReturn();
    }

    public void apply(MkvElementVisitor visitor) throws MkvElementVisitException {
        while (this.mightHaveNext() && !visitor.isDone()) {
            Optional<MkvElement> mkvElementOptional = this.nextIfAvailable();
            if (!mkvElementOptional.isPresent()) continue;
            mkvElementOptional.get().accept(visitor);
        }
    }

    private Optional<MkvElement> getMkvElementToReturn() {
        Optional<MkvElement> currentElement = this.mkvStreamReaderCallback.getMkvElementIfAvailable();
        if (currentElement.isPresent()) {
            if (this.previousDataElement.isPresent()) {
                this.previousDataElement.get().clearDataBuffer();
                this.previousDataElement = Optional.empty();
            }
            if (!currentElement.get().isMaster()) {
                this.previousDataElement = Optional.of((MkvDataElement)currentElement.get());
            }
        }
        return currentElement;
    }

    private Predicate<EBMLTypeInfo> elementFilter() {
        if (this.typeInfosToRead.size() == 0) {
            return t -> t.getType() != EBMLTypeInfo.TYPE.MASTER;
        }
        return this.typeInfosToRead::contains;
    }
}

