/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.mkv.visitors;

import com.amazonaws.kinesisvideo.parser.mkv.MkvDataElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitException;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.MkvEndMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvStartMasterElement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeMkvElementVisitor
extends MkvElementVisitor {
    private static final Logger log = LoggerFactory.getLogger(CompositeMkvElementVisitor.class);
    protected final List<MkvElementVisitor> childVisitors;

    public CompositeMkvElementVisitor(MkvElementVisitor ... visitors) {
        this.childVisitors = new ArrayList<MkvElementVisitor>();
        for (MkvElementVisitor visitor : visitors) {
            this.childVisitors.add(visitor);
        }
    }

    @Override
    public void visit(MkvStartMasterElement startMasterElement) throws MkvElementVisitException {
        this.visitAll(startMasterElement);
    }

    @Override
    public void visit(MkvEndMasterElement endMasterElement) throws MkvElementVisitException {
        this.visitAll(endMasterElement);
    }

    @Override
    public void visit(MkvDataElement dataElement) throws MkvElementVisitException {
        this.visitAll(dataElement);
    }

    @Override
    public boolean isDone() {
        return this.childVisitors.stream().anyMatch(MkvElementVisitor::isDone);
    }

    private void visitAll(MkvElement element) throws MkvElementVisitException {
        for (MkvElementVisitor childVisitor : this.childVisitors) {
            if (log.isDebugEnabled()) {
                log.debug("Composite visitor calling {} on element {}", (Object)childVisitor.getClass().toString(), (Object)element.toString());
            }
            element.accept(childVisitor);
        }
    }

    protected CompositeMkvElementVisitor(List<MkvElementVisitor> childVisitors) {
        this.childVisitors = childVisitors;
    }
}

