/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.mkv.visitors;

import com.amazonaws.kinesisvideo.parser.ebml.EBMLTypeInfo;
import com.amazonaws.kinesisvideo.parser.mkv.MkvDataElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.MkvEndMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvStartMasterElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountVisitor
extends MkvElementVisitor {
    private static final Logger log = LoggerFactory.getLogger(CountVisitor.class);
    private final Set<EBMLTypeInfo> typesToCount = new HashSet<EBMLTypeInfo>();
    private final Map<EBMLTypeInfo, Integer> typeCount = new HashMap<EBMLTypeInfo, Integer>();
    private final Map<EBMLTypeInfo, Integer> endMasterCount = new HashMap<EBMLTypeInfo, Integer>();

    public CountVisitor(Collection<EBMLTypeInfo> typesToCount) {
        this.typesToCount.addAll(typesToCount);
        this.typesToCount.stream().forEach(t -> this.typeCount.put((EBMLTypeInfo)t, 0));
        this.typesToCount.stream().filter(t -> t.getType().equals((Object)EBMLTypeInfo.TYPE.MASTER)).forEach(t -> this.endMasterCount.put((EBMLTypeInfo)t, 0));
    }

    public static CountVisitor create(EBMLTypeInfo ... typesToCount) {
        ArrayList<EBMLTypeInfo> typeInfoList = new ArrayList<EBMLTypeInfo>();
        for (EBMLTypeInfo typeToCount : typesToCount) {
            typeInfoList.add(typeToCount);
        }
        return new CountVisitor(typeInfoList);
    }

    @Override
    public void visit(MkvStartMasterElement startMasterElement) {
        this.incrementTypeCount(startMasterElement);
    }

    @Override
    public void visit(MkvEndMasterElement endMasterElement) {
        this.incrementCount(endMasterElement, this.endMasterCount);
    }

    @Override
    public void visit(MkvDataElement dataElement) {
        this.incrementTypeCount(dataElement);
    }

    public int getCount(EBMLTypeInfo typeInfo) {
        return this.typeCount.getOrDefault(typeInfo, 0);
    }

    public boolean doEndAndStartMasterElementsMatch() {
        List mismatchedStartAndEnd = this.typeCount.entrySet().stream().filter(e -> ((EBMLTypeInfo)e.getKey()).getType().equals((Object)EBMLTypeInfo.TYPE.MASTER)).filter(e -> this.typeCount.get(e.getKey()) != this.endMasterCount.get(e.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!mismatchedStartAndEnd.isEmpty()) {
            log.warn(" Some end and master element counts did not match: ");
            mismatchedStartAndEnd.stream().forEach(t -> log.warn("Element {} start count {} end count {}", new Object[]{t, this.typeCount.get(t), this.endMasterCount.get(t)}));
            return false;
        }
        return true;
    }

    private void incrementTypeCount(MkvElement mkvElement) {
        this.incrementCount(mkvElement, this.typeCount);
    }

    private void incrementCount(MkvElement mkvElement, Map<EBMLTypeInfo, Integer> mapToUpdate) {
        if (this.typesToCount.contains(mkvElement.getElementMetaData().getTypeInfo())) {
            log.debug("Element {} to Count found", (Object)mkvElement);
            int oldValue = mapToUpdate.get(mkvElement.getElementMetaData().getTypeInfo());
            mapToUpdate.put(mkvElement.getElementMetaData().getTypeInfo(), oldValue + 1);
        }
    }
}

