/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.mkv.visitors;

import com.amazonaws.kinesisvideo.parser.ebml.MkvTypeInfos;
import com.amazonaws.kinesisvideo.parser.mkv.Frame;
import com.amazonaws.kinesisvideo.parser.mkv.MkvDataElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitException;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.MkvEndMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvStartMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvValue;
import java.io.BufferedWriter;
import java.io.IOException;
import java.math.BigInteger;

public class ElementSizeAndOffsetVisitor
extends MkvElementVisitor {
    private final BufferedWriter writer;
    private long offsetCount = 0L;

    @Override
    public void visit(MkvStartMasterElement startMasterElement) throws MkvElementVisitException {
        StringBuilder builder = new StringBuilder();
        this.appendOffset(startMasterElement, builder);
        this.appendCommonParts(startMasterElement, builder);
        builder.append(" element header size ").append(startMasterElement.getIdAndSizeRawBytesLength()).append(" element data size ");
        if (startMasterElement.isUnknownLength()) {
            builder.append("unknown");
        } else {
            builder.append(startMasterElement.getDataSize());
        }
        this.offsetCount += (long)startMasterElement.getIdAndSizeRawBytesLength();
        this.buildAndWrite(builder);
    }

    @Override
    public void visit(MkvEndMasterElement endMasterElement) {
    }

    @Override
    public void visit(MkvDataElement dataElement) throws MkvElementVisitException {
        StringBuilder builder = this.createStringBuilderWithOffset(dataElement);
        this.appendCommonParts(dataElement, builder);
        builder.append(" element header size ").append(dataElement.getIdAndSizeRawBytesLength()).append(" element data size ").append(dataElement.getDataSize());
        this.offsetCount += (long)dataElement.getIdAndSizeRawBytesLength();
        this.offsetCount += dataElement.getDataSize();
        this.buildAndWrite(builder);
        if (MkvTypeInfos.SIMPLEBLOCK.equals(dataElement.getElementMetaData().getTypeInfo())) {
            MkvValue frameValue = dataElement.getValueCopy();
            Frame frame = (Frame)frameValue.getVal();
            this.buildAndWrite(this.createStringBuilderWithOffset(dataElement).append("Frame data (size): ").append(frame.getFrameData().limit()).append(" ").append(frame.toString()));
        } else if (MkvTypeInfos.TAGNAME.equals(dataElement.getElementMetaData().getTypeInfo())) {
            MkvValue tagName = dataElement.getValueCopy();
            this.buildAndWrite(this.createStringBuilderWithOffset(dataElement).append("Tag Name :").append((String)tagName.getVal()));
        } else if (MkvTypeInfos.TIMECODE.equals(dataElement.getElementMetaData().getTypeInfo())) {
            MkvValue timeCode = dataElement.getValueCopy();
            this.buildAndWrite(this.createStringBuilderWithOffset(dataElement).append("TimeCode :").append(((BigInteger)timeCode.getVal()).toString()));
        }
    }

    private StringBuilder createStringBuilderWithOffset(MkvDataElement dataElement) {
        StringBuilder frameStringBuilder = new StringBuilder();
        this.appendOffset(dataElement, frameStringBuilder);
        return frameStringBuilder;
    }

    private void appendCommonParts(MkvElement mkvElement, StringBuilder builder) {
        builder.append("Element ").append(mkvElement.getElementMetaData().getTypeInfo().getName()).append(" elementNumber ").append(mkvElement.getElementMetaData().getElementNumber()).append(" offset ").append(this.offsetCount);
    }

    private void appendOffset(MkvElement element, StringBuilder builder) {
        int level = Math.max(0, element.getElementMetaData().getTypeInfo().getLevel());
        for (int i = 0; i < level; ++i) {
            builder.append("    ");
        }
    }

    private void buildAndWrite(StringBuilder builder) throws MkvElementVisitException {
        try {
            String s = builder.toString();
            this.writer.write(s, 0, s.length());
            this.writer.newLine();
        }
        catch (IOException e) {
            throw new MkvElementVisitException("Failure in ElementSizeAndOffsetVisitor ", e);
        }
    }

    public ElementSizeAndOffsetVisitor(BufferedWriter writer) {
        this.writer = writer;
    }
}

