/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities;

import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;

public class FragmentMetadata {
    private static final String FRAGMENT_NUMBER_KEY = "AWS_KINESISVIDEO_FRAGMENT_NUMBER";
    private static final String SERVER_SIDE_TIMESTAMP_KEY = "AWS_KINESISVIDEO_SERVER_TIMESTAMP";
    private static final String PRODCUER_SIDE_TIMESTAMP_KEY = "AWS_KINESISVIDEO_PRODUCER_TIMESTAMP";
    private static final String ERROR_CODE_KEY = "AWS_KINESISVIDEO_ERROR_CODE";
    private static final String ERROR_ID_KEY = "AWS_KINESISVIDEO_ERROR_ID";
    private static final long MILLIS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private final String fragmentNumberString;
    private final long serverSideTimestampMillis;
    private final long producerSideTimestampMillis;
    private final BigInteger fragmentNumber;
    private final boolean success;
    private final long errorId;
    private final String errorCode;
    private OptionalLong millisBehindNow = OptionalLong.empty();
    private Optional<String> continuationToken = Optional.empty();

    private FragmentMetadata(String fragmentNumberString, double serverSideTimestampSeconds, double producerSideTimestampSeconds) {
        this(fragmentNumberString, FragmentMetadata.convertToMillis(serverSideTimestampSeconds), FragmentMetadata.convertToMillis(producerSideTimestampSeconds), true, 0L, null);
    }

    private FragmentMetadata(String fragmentNumberString, long errorId, String errorCode) {
        this(fragmentNumberString, -1L, -1L, false, errorId, errorCode);
    }

    private FragmentMetadata(String fragmentNumberString, long serverSideTimestampMillis, long producerSideTimestampMillis, boolean success, long errorId, String errorCode) {
        this.fragmentNumberString = fragmentNumberString;
        this.fragmentNumber = new BigInteger(fragmentNumberString);
        this.serverSideTimestampMillis = serverSideTimestampMillis;
        this.producerSideTimestampMillis = producerSideTimestampMillis;
        this.success = success;
        this.errorId = errorId;
        this.errorCode = errorCode;
    }

    private static long convertToMillis(double serverSideTimestampSeconds) {
        return (long)Math.ceil(serverSideTimestampSeconds * (double)MILLIS_PER_SECOND);
    }

    static FragmentMetadata createFromtagNametoValueMap(Map<String, String> tagNameToTagValueMap) {
        if (tagNameToTagValueMap.containsKey(SERVER_SIDE_TIMESTAMP_KEY)) {
            return new FragmentMetadata(FragmentMetadata.getValueForTag(tagNameToTagValueMap, FRAGMENT_NUMBER_KEY), Double.parseDouble(FragmentMetadata.getValueForTag(tagNameToTagValueMap, SERVER_SIDE_TIMESTAMP_KEY)), Double.parseDouble(FragmentMetadata.getValueForTag(tagNameToTagValueMap, PRODCUER_SIDE_TIMESTAMP_KEY)));
        }
        if (tagNameToTagValueMap.containsKey(FRAGMENT_NUMBER_KEY)) {
            return new FragmentMetadata(FragmentMetadata.getValueForTag(tagNameToTagValueMap, FRAGMENT_NUMBER_KEY), Long.parseLong(FragmentMetadata.getValueForTag(tagNameToTagValueMap, ERROR_ID_KEY)), FragmentMetadata.getValueForTag(tagNameToTagValueMap, ERROR_CODE_KEY));
        }
        return null;
    }

    private static String getValueForTag(Map<String, String> tagNameToTagValueMap, String tagName) {
        String tagVal = tagNameToTagValueMap.get(tagName);
        return (String)Validate.notEmpty((CharSequence)tagVal, (String)("tagName " + tagName), (Object[])new Object[0]);
    }

    public Date getServerSideTimestampAsDate() {
        return new Date(this.serverSideTimestampMillis);
    }

    public Date getProducerSideTimetampAsDate() {
        return new Date(this.producerSideTimestampMillis);
    }

    public boolean isCompleteFragment() {
        return this.millisBehindNow.isPresent() && this.continuationToken.isPresent();
    }

    public String getFragmentNumberString() {
        return this.fragmentNumberString;
    }

    public long getServerSideTimestampMillis() {
        return this.serverSideTimestampMillis;
    }

    public long getProducerSideTimestampMillis() {
        return this.producerSideTimestampMillis;
    }

    public BigInteger getFragmentNumber() {
        return this.fragmentNumber;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public long getErrorId() {
        return this.errorId;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public OptionalLong getMillisBehindNow() {
        return this.millisBehindNow;
    }

    public Optional<String> getContinuationToken() {
        return this.continuationToken;
    }

    public String toString() {
        return "FragmentMetadata(fragmentNumberString=" + this.getFragmentNumberString() + ", serverSideTimestampMillis=" + this.getServerSideTimestampMillis() + ", producerSideTimestampMillis=" + this.getProducerSideTimestampMillis() + ", fragmentNumber=" + this.getFragmentNumber() + ", success=" + this.isSuccess() + ", errorId=" + this.getErrorId() + ", errorCode=" + this.getErrorCode() + ", millisBehindNow=" + this.getMillisBehindNow() + ", continuationToken=" + this.getContinuationToken() + ")";
    }

    public void setMillisBehindNow(OptionalLong millisBehindNow) {
        this.millisBehindNow = millisBehindNow;
    }

    public void setContinuationToken(Optional<String> continuationToken) {
        this.continuationToken = continuationToken;
    }
}

