/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities;

import com.amazonaws.kinesisvideo.parser.ebml.EBMLElementMetaData;
import com.amazonaws.kinesisvideo.parser.ebml.EBMLTypeInfo;
import com.amazonaws.kinesisvideo.parser.ebml.MkvTypeInfos;
import com.amazonaws.kinesisvideo.parser.mkv.MkvDataElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitException;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.MkvEndMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvStartMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvValue;
import com.amazonaws.kinesisvideo.parser.mkv.visitors.CompositeMkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.FragmentMetadata;
import com.amazonaws.kinesisvideo.parser.utilities.MkvChildElementCollector;
import com.amazonaws.kinesisvideo.parser.utilities.MkvTag;
import com.amazonaws.kinesisvideo.parser.utilities.MkvTrackMetadata;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentMetadataVisitor
extends CompositeMkvElementVisitor {
    private static final Logger log = LoggerFactory.getLogger(FragmentMetadataVisitor.class);
    private static final String MILLIS_BEHIND_NOW_KEY = "AWS_KINESISVIDEO_MILLIS_BEHIND_NOW";
    private static final String CONTINUATION_TOKEN_KEY = "AWS_KINESISVIDEO_CONTINUATION_TOKEN";
    private static final EBMLTypeInfo[] TRACK_TYPES = new EBMLTypeInfo[]{MkvTypeInfos.TRACKNUMBER, MkvTypeInfos.TRACKUID, MkvTypeInfos.NAME, MkvTypeInfos.CODECID, MkvTypeInfos.CODECNAME, MkvTypeInfos.CODECPRIVATE, MkvTypeInfos.PIXELWIDTH, MkvTypeInfos.PIXELHEIGHT};
    private static final String AWS_KINESISVIDEO_TAGNAME_PREFIX = "AWS_KINESISVIDEO";
    private final MkvChildElementCollector tagCollector;
    private final MkvChildElementCollector trackCollector;
    private final StateMachineVisitor stateMachineVisitor;
    private final Optional<MkvTagProcessor> mkvTagProcessor;
    private final Set<EBMLTypeInfo> trackTypesForTrackMetadata = new HashSet<EBMLTypeInfo>();
    private Optional<FragmentMetadata> previousFragmentMetadata = Optional.empty();
    private Optional<FragmentMetadata> currentFragmentMetadata = Optional.empty();
    private OptionalLong millisBehindNow = OptionalLong.empty();
    private Optional<String> continuationToken = Optional.empty();
    private final Map<BigInteger, MkvTrackMetadata> trackMetadataMap = new HashMap<BigInteger, MkvTrackMetadata>();
    private String tagName = null;
    private String tagValue = null;

    private FragmentMetadataVisitor(List<MkvElementVisitor> childVisitors, MkvChildElementCollector tagCollector, MkvChildElementCollector trackCollector, Optional<MkvTagProcessor> mkvTagProcessor) {
        super(childVisitors);
        Validate.isTrue((boolean)tagCollector.getParentTypeInfo().equals(MkvTypeInfos.TAGS));
        Validate.isTrue((boolean)trackCollector.getParentTypeInfo().equals(MkvTypeInfos.TRACKS));
        this.tagCollector = tagCollector;
        this.trackCollector = trackCollector;
        this.stateMachineVisitor = new StateMachineVisitor();
        this.childVisitors.add(this.stateMachineVisitor);
        this.mkvTagProcessor = mkvTagProcessor;
        for (EBMLTypeInfo trackType : TRACK_TYPES) {
            this.trackTypesForTrackMetadata.add(trackType);
        }
    }

    public static FragmentMetadataVisitor create() {
        return FragmentMetadataVisitor.create(Optional.empty());
    }

    public static FragmentMetadataVisitor create(Optional<MkvTagProcessor> mkvTagProcessor) {
        ArrayList<MkvElementVisitor> childVisitors = new ArrayList<MkvElementVisitor>();
        MkvChildElementCollector tagCollector = new MkvChildElementCollector(MkvTypeInfos.TAGS);
        MkvChildElementCollector trackCollector = new MkvChildElementCollector(MkvTypeInfos.TRACKS);
        childVisitors.add(tagCollector);
        childVisitors.add(trackCollector);
        return new FragmentMetadataVisitor(childVisitors, tagCollector, trackCollector, mkvTagProcessor);
    }

    public MkvTrackMetadata getMkvTrackMetadata(long trackNumber) {
        return this.trackMetadataMap.get(BigInteger.valueOf(trackNumber));
    }

    public OptionalLong getMillisBehindNow() {
        return this.millisBehindNow;
    }

    public Optional<String> getContinuationToken() {
        return this.continuationToken;
    }

    private void setMillisBehindLatestAndContinuationToken() {
        String continutationTokenString;
        Map<String, String> tagNameToTagValueMap = this.getTagNameToValueMap();
        String millisBehindString = tagNameToTagValueMap.get(MILLIS_BEHIND_NOW_KEY);
        if (millisBehindString != null) {
            this.millisBehindNow = OptionalLong.of(Long.parseLong(millisBehindString));
            this.currentFragmentMetadata.ifPresent(f -> f.setMillisBehindNow(this.millisBehindNow));
        }
        if ((continutationTokenString = tagNameToTagValueMap.get(CONTINUATION_TOKEN_KEY)) != null) {
            this.continuationToken = Optional.of(continutationTokenString);
            this.currentFragmentMetadata.ifPresent(f -> f.setContinuationToken(this.continuationToken));
        }
    }

    private void collectPreClusterInfo() {
        Map<String, String> tagNameToTagValueMap = this.getTagNameToValueMap();
        this.currentFragmentMetadata = Optional.ofNullable(FragmentMetadata.createFromtagNametoValueMap(tagNameToTagValueMap));
        Map<Long, List<MkvElement>> trackEntryElementNumberToMkvElement = this.getTrackEntryMap();
        trackEntryElementNumberToMkvElement.values().stream().forEach(this::createTrackMetadata);
    }

    private Map<Long, List<MkvElement>> getTrackEntryMap() {
        HashMap<Long, List<MkvElement>> trackEntryElementNumberToMkvElement = new HashMap<Long, List<MkvElement>>();
        List<MkvElement> trackElements = this.trackCollector.copyOfCollection();
        trackElements.stream().filter(e -> MkvTypeInfos.TRACKENTRY.equals(e.getElementMetaData().getTypeInfo())).forEach(e -> {
            List cfr_ignored_0 = trackEntryElementNumberToMkvElement.put(e.getElementMetaData().getElementNumber(), new ArrayList());
        });
        trackElements.stream().filter(e -> e.getElementMetaData().getTypeInfo().getLevel() > MkvTypeInfos.TRACKENTRY.getLevel()).forEach(e -> {
            EBMLElementMetaData trackEntryParent = e.getElementPath().get(MkvTypeInfos.TRACKENTRY.getLevel());
            Validate.isTrue((boolean)MkvTypeInfos.TRACKENTRY.equals(trackEntryParent.getTypeInfo()));
            ((List)trackEntryElementNumberToMkvElement.get(trackEntryParent.getElementNumber())).add(e);
        });
        return trackEntryElementNumberToMkvElement;
    }

    private void createTrackMetadata(List<MkvElement> trackEntryPropertyLists) {
        Map<EBMLTypeInfo, MkvElement> metaDataProperties = trackEntryPropertyLists.stream().filter(e -> this.trackTypesForTrackMetadata.contains(e.getElementMetaData().getTypeInfo())).collect(Collectors.toMap(e -> e.getElementMetaData().getTypeInfo(), Function.identity()));
        MkvTrackMetadata mkvTrackMetadata = MkvTrackMetadata.builder().trackNumber(FragmentMetadataVisitor.getUnsignedLongVal(metaDataProperties, MkvTypeInfos.TRACKNUMBER)).trackUID(FragmentMetadataVisitor.getUnsignedLongValOptional(metaDataProperties, MkvTypeInfos.TRACKUID)).trackName(FragmentMetadataVisitor.getStringVal(metaDataProperties, MkvTypeInfos.NAME)).codecId(FragmentMetadataVisitor.getStringVal(metaDataProperties, MkvTypeInfos.CODECID)).codecName(FragmentMetadataVisitor.getStringVal(metaDataProperties, MkvTypeInfos.CODECNAME)).codecPrivateData(FragmentMetadataVisitor.getByteBuffer(metaDataProperties, MkvTypeInfos.CODECPRIVATE)).pixelWidth(FragmentMetadataVisitor.getUnsignedLongValOptional(metaDataProperties, MkvTypeInfos.PIXELWIDTH)).pixelHeight(FragmentMetadataVisitor.getUnsignedLongValOptional(metaDataProperties, MkvTypeInfos.PIXELHEIGHT)).samplingFrequency(FragmentMetadataVisitor.getFloatingPointValOptional(metaDataProperties, MkvTypeInfos.SAMPLINGFREQUENCY)).channels(FragmentMetadataVisitor.getUnsignedLongValOptional(metaDataProperties, MkvTypeInfos.CHANNELS)).bitDepth(FragmentMetadataVisitor.getUnsignedLongValOptional(metaDataProperties, MkvTypeInfos.BITDEPTH)).allElementsInTrack(trackEntryPropertyLists).build();
        this.trackMetadataMap.put(mkvTrackMetadata.getTrackNumber(), mkvTrackMetadata);
    }

    private static String getStringVal(Map<EBMLTypeInfo, MkvElement> metaDataProperties, EBMLTypeInfo key) {
        MkvElement element = metaDataProperties.get(key);
        if (element == null) {
            return null;
        }
        MkvDataElement dataElement = (MkvDataElement)element;
        Validate.isTrue((EBMLTypeInfo.TYPE.STRING.equals((Object)dataElement.getElementMetaData().getTypeInfo().getType()) || EBMLTypeInfo.TYPE.UTF_8.equals((Object)dataElement.getElementMetaData().getTypeInfo().getType()) ? 1 : 0) != 0);
        return (String)dataElement.getValueCopy().getVal();
    }

    private static Optional<BigInteger> getUnsignedLongValOptional(Map<EBMLTypeInfo, MkvElement> metaDataProperties, EBMLTypeInfo key) {
        return Optional.ofNullable(FragmentMetadataVisitor.getUnsignedLongVal(metaDataProperties, key));
    }

    private static BigInteger getUnsignedLongVal(Map<EBMLTypeInfo, MkvElement> metaDataProperties, EBMLTypeInfo key) {
        MkvElement element = metaDataProperties.get(key);
        if (element == null) {
            return null;
        }
        MkvDataElement dataElement = (MkvDataElement)element;
        Validate.isTrue((boolean)EBMLTypeInfo.TYPE.UINTEGER.equals((Object)dataElement.getElementMetaData().getTypeInfo().getType()));
        return (BigInteger)dataElement.getValueCopy().getVal();
    }

    private static Optional<Double> getFloatingPointValOptional(Map<EBMLTypeInfo, MkvElement> metaDataProperties, EBMLTypeInfo key) {
        return Optional.ofNullable(FragmentMetadataVisitor.getFloatingPointVal(metaDataProperties, key));
    }

    private static Double getFloatingPointVal(Map<EBMLTypeInfo, MkvElement> metaDataProperties, EBMLTypeInfo key) {
        MkvElement element = metaDataProperties.get(key);
        if (element == null) {
            return null;
        }
        MkvDataElement dataElement = (MkvDataElement)element;
        Validate.isTrue((boolean)EBMLTypeInfo.TYPE.FLOAT.equals((Object)dataElement.getElementMetaData().getTypeInfo().getType()));
        return (Double)dataElement.getValueCopy().getVal();
    }

    private static ByteBuffer getByteBuffer(Map<EBMLTypeInfo, MkvElement> metaDataProperties, EBMLTypeInfo key) {
        MkvElement element = metaDataProperties.get(key);
        if (element == null) {
            return null;
        }
        MkvDataElement dataElement = (MkvDataElement)element;
        Validate.isTrue((boolean)EBMLTypeInfo.TYPE.BINARY.equals((Object)dataElement.getElementMetaData().getTypeInfo().getType()));
        return (ByteBuffer)dataElement.getValueCopy().getVal();
    }

    private Map<String, String> getTagNameToValueMap() {
        List<MkvElement> tagElements = this.tagCollector.copyOfCollection();
        Map<String, Long> tagNameToParentElementNumber = tagElements.stream().filter(e -> MkvTypeInfos.TAGNAME.equals(e.getElementMetaData().getTypeInfo())).filter(e -> MkvTypeInfos.SIMPLETAG.equals(FragmentMetadataVisitor.getParentElement(e).getTypeInfo())).filter(e -> FragmentMetadataVisitor.isTagFromKinesisVideo((MkvDataElement)e)).collect(Collectors.toMap(this::getMkvElementStringVal, e -> FragmentMetadataVisitor.getParentElement(e).getElementNumber(), (a, b) -> b));
        Map<Long, String> parentElementNumberToTagValue = tagElements.stream().filter(e -> MkvTypeInfos.TAGSTRING.equals(e.getElementMetaData().getTypeInfo())).filter(e -> MkvTypeInfos.SIMPLETAG.equals(FragmentMetadataVisitor.getParentElement(e).getTypeInfo())).collect(Collectors.toMap(e -> FragmentMetadataVisitor.getParentElement(e).getElementNumber(), this::getMkvElementStringVal));
        return tagNameToParentElementNumber.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> parentElementNumberToTagValue.getOrDefault(e.getValue(), "")));
    }

    private static boolean isTagFromKinesisVideo(MkvDataElement e) {
        MkvValue tagNameValue = e.getValueCopy();
        return ((String)tagNameValue.getVal()).startsWith(AWS_KINESISVIDEO_TAGNAME_PREFIX);
    }

    private String getMkvElementStringVal(MkvElement e) {
        return (String)((MkvDataElement)e).getValueCopy().getVal();
    }

    private static EBMLElementMetaData getParentElement(MkvElement e) {
        return e.getElementPath().get(e.getElementPath().size() - 1);
    }

    private void resetCollectedData() {
        this.previousFragmentMetadata = this.currentFragmentMetadata;
        this.currentFragmentMetadata = Optional.empty();
        this.trackMetadataMap.clear();
        this.tagValue = null;
        this.tagName = null;
        this.tagCollector.clearCollection();
        this.trackCollector.clearCollection();
    }

    public Optional<FragmentMetadata> getPreviousFragmentMetadata() {
        return this.previousFragmentMetadata;
    }

    public Optional<FragmentMetadata> getCurrentFragmentMetadata() {
        return this.currentFragmentMetadata;
    }

    public static final class BasicMkvTagProcessor
    implements MkvTagProcessor {
        private List<MkvTag> tags = new ArrayList<MkvTag>();

        @Override
        public void process(MkvTag mkvTag, Optional<FragmentMetadata> currentFragmentMetadata) {
            this.tags.add(mkvTag);
        }

        @Override
        public void clear() {
            this.tags.clear();
        }

        public List<MkvTag> getTags() {
            return this.tags;
        }
    }

    private class StateMachineVisitor
    extends MkvElementVisitor {
        State state = State.NEW;

        private StateMachineVisitor() {
        }

        @Override
        public void visit(MkvStartMasterElement startMasterElement) throws MkvElementVisitException {
            switch (this.state) {
                case NEW: {
                    if (!MkvTypeInfos.SEGMENT.equals(startMasterElement.getElementMetaData().getTypeInfo())) break;
                    log.debug("Segment start {} changing state to PRE_CLUSTER", (Object)startMasterElement);
                    FragmentMetadataVisitor.this.resetCollectedData();
                    this.state = State.PRE_CLUSTER;
                    break;
                }
                case PRE_CLUSTER: {
                    if (!MkvTypeInfos.CLUSTER.equals(startMasterElement.getElementMetaData().getTypeInfo())) break;
                    log.debug("Cluster start {} changing state to IN_CLUSTER", (Object)startMasterElement);
                    FragmentMetadataVisitor.this.collectPreClusterInfo();
                    this.state = State.IN_CLUSTER;
                    break;
                }
            }
        }

        @Override
        public void visit(MkvEndMasterElement endMasterElement) throws MkvElementVisitException {
            switch (this.state) {
                case IN_CLUSTER: {
                    if (!MkvTypeInfos.CLUSTER.equals(endMasterElement.getElementMetaData().getTypeInfo())) break;
                    this.state = State.POST_CLUSTER;
                    break;
                }
                case POST_CLUSTER: {
                    if (!MkvTypeInfos.SEGMENT.equals(endMasterElement.getElementMetaData().getTypeInfo())) break;
                    log.debug("Segment end {} changing state to NEW", (Object)endMasterElement);
                    this.state = State.NEW;
                    break;
                }
                case PRE_CLUSTER: {
                    if (!MkvTypeInfos.SEGMENT.equals(endMasterElement.getElementMetaData().getTypeInfo())) break;
                    log.warn("Segment end {} while in PRE_CLUSTER. Collecting cluster info", (Object)endMasterElement);
                    FragmentMetadataVisitor.this.collectPreClusterInfo();
                    break;
                }
            }
            if (MkvTypeInfos.TAGS.equals(endMasterElement.getElementMetaData().getTypeInfo())) {
                if (log.isDebugEnabled()) {
                    log.debug("TAGS end {}, potentially updating millisbehindlatest and continuation token", (Object)endMasterElement);
                }
                FragmentMetadataVisitor.this.setMillisBehindLatestAndContinuationToken();
            }
        }

        @Override
        public void visit(MkvDataElement dataElement) throws MkvElementVisitException {
            if (FragmentMetadataVisitor.this.mkvTagProcessor.isPresent()) {
                if (MkvTypeInfos.TAGNAME.equals(dataElement.getElementMetaData().getTypeInfo())) {
                    FragmentMetadataVisitor.this.tagName = FragmentMetadataVisitor.this.getMkvElementStringVal(dataElement);
                } else if (MkvTypeInfos.TAGSTRING.equals(dataElement.getElementMetaData().getTypeInfo())) {
                    FragmentMetadataVisitor.this.tagValue = FragmentMetadataVisitor.this.getMkvElementStringVal(dataElement);
                }
                if (FragmentMetadataVisitor.this.tagName != null && FragmentMetadataVisitor.this.tagValue != null) {
                    if (!FragmentMetadataVisitor.this.tagName.startsWith(FragmentMetadataVisitor.AWS_KINESISVIDEO_TAGNAME_PREFIX)) {
                        ((MkvTagProcessor)FragmentMetadataVisitor.this.mkvTagProcessor.get()).process(new MkvTag(FragmentMetadataVisitor.this.tagName, FragmentMetadataVisitor.this.tagValue), FragmentMetadataVisitor.this.currentFragmentMetadata);
                    }
                    FragmentMetadataVisitor.this.tagName = null;
                    FragmentMetadataVisitor.this.tagValue = null;
                }
            }
        }
    }

    static enum State {
        NEW,
        PRE_CLUSTER,
        IN_CLUSTER,
        POST_CLUSTER;

    }

    public static interface MkvTagProcessor {
        default public void process(MkvTag mkvTag, Optional<FragmentMetadata> currentFragmentMetadata) {
            throw new NotImplementedException("Default FragmentMetadataVisitor.MkvTagProcessor");
        }

        default public void clear() {
            throw new NotImplementedException("Default FragmentMetadataVisitor.MkvTagProcessor");
        }
    }
}

