/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities;

import com.amazonaws.kinesisvideo.parser.examples.KinesisVideoFrameViewer;
import com.amazonaws.kinesisvideo.parser.mkv.Frame;
import com.amazonaws.kinesisvideo.parser.mkv.MkvDataElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitException;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.MkvEndMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvStartMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvValue;
import com.amazonaws.kinesisvideo.parser.mkv.visitors.CompositeMkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.FragmentMetadataVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.MkvTrackMetadata;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.List;
import org.jcodec.codecs.h264.H264Decoder;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.mp4.AvcCBox;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.scale.AWTUtil;
import org.jcodec.scale.Transform;
import org.jcodec.scale.Yuv420jToRgb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameRendererVisitor
extends CompositeMkvElementVisitor {
    private static final Logger log = LoggerFactory.getLogger(FrameRendererVisitor.class);
    private final KinesisVideoFrameViewer kinesisVideoFrameViewer;
    private final FragmentMetadataVisitor fragmentMetadataVisitor;
    private final FrameVisitorInternal frameVisitorInternal;
    private final H264Decoder decoder = new H264Decoder();
    private final Transform transform = new Yuv420jToRgb();
    private int frameCount;
    private byte[] codecPrivateData;

    private FrameRendererVisitor(FragmentMetadataVisitor fragmentMetadataVisitor, KinesisVideoFrameViewer kinesisVideoFrameViewer) {
        super(fragmentMetadataVisitor);
        this.fragmentMetadataVisitor = fragmentMetadataVisitor;
        this.kinesisVideoFrameViewer = kinesisVideoFrameViewer;
        this.kinesisVideoFrameViewer.setVisible(true);
        this.frameVisitorInternal = new FrameVisitorInternal();
        this.childVisitors.add(this.frameVisitorInternal);
    }

    public static FrameRendererVisitor create(KinesisVideoFrameViewer kinesisVideoFrameViewer) {
        return new FrameRendererVisitor(FragmentMetadataVisitor.create(), kinesisVideoFrameViewer);
    }

    public ByteBuffer getCodecPrivateData() {
        return ByteBuffer.wrap(this.codecPrivateData);
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    static /* synthetic */ byte[] access$302(FrameRendererVisitor x0, byte[] x1) {
        x0.codecPrivateData = x1;
        return x1;
    }

    private class FrameVisitorInternal
    extends MkvElementVisitor {
        private FrameVisitorInternal() {
        }

        @Override
        public void visit(MkvStartMasterElement startMasterElement) throws MkvElementVisitException {
        }

        @Override
        public void visit(MkvEndMasterElement endMasterElement) throws MkvElementVisitException {
        }

        @Override
        public void visit(MkvDataElement dataElement) throws MkvElementVisitException {
            log.info("Got data element: {}", (Object)dataElement.getElementMetaData().getTypeInfo().getName());
            String dataElementName = dataElement.getElementMetaData().getTypeInfo().getName();
            if ("SimpleBlock".equals(dataElementName)) {
                MkvValue frame = dataElement.getValueCopy();
                ByteBuffer frameBuffer = ((Frame)frame.getVal()).getFrameData();
                MkvTrackMetadata trackMetadata = FrameRendererVisitor.this.fragmentMetadataVisitor.getMkvTrackMetadata(((Frame)frame.getVal()).getTrackNumber());
                int pixelWidth = trackMetadata.getPixelWidth().get().intValue();
                int pixelHeight = trackMetadata.getPixelHeight().get().intValue();
                FrameRendererVisitor.access$302(FrameRendererVisitor.this, trackMetadata.getCodecPrivateData().array());
                log.debug("Decoding frames ... ");
                Picture rgb = Picture.create((int)pixelWidth, (int)pixelHeight, (ColorSpace)ColorSpace.RGB);
                BufferedImage renderImage = new BufferedImage(pixelWidth, pixelHeight, 5);
                AvcCBox avcC = AvcCBox.parseAvcCBox((ByteBuffer)ByteBuffer.wrap(FrameRendererVisitor.this.codecPrivateData));
                FrameRendererVisitor.this.decoder.addSps(avcC.getSpsList());
                FrameRendererVisitor.this.decoder.addPps(avcC.getPpsList());
                Picture buf = Picture.create((int)(pixelWidth + (16 - pixelWidth % 16) % 16), (int)(pixelHeight + (16 - pixelHeight % 16) % 16), (ColorSpace)ColorSpace.YUV420J);
                List byteBuffers = H264Utils.splitMOVPacket((ByteBuffer)frameBuffer, (AvcCBox)avcC);
                org.jcodec.codecs.h264.io.model.Frame pic = FrameRendererVisitor.this.decoder.decodeFrameFromNals(byteBuffers, buf.getData());
                if (pic != null) {
                    byte[][] dataTemp = new byte[3][pic.getData().length];
                    dataTemp[0] = pic.getPlaneData(0);
                    dataTemp[1] = pic.getPlaneData(2);
                    dataTemp[2] = pic.getPlaneData(1);
                    Picture tmpBuf = Picture.createPicture((int)pixelWidth, (int)pixelHeight, (byte[][])dataTemp, (ColorSpace)ColorSpace.YUV420J);
                    FrameRendererVisitor.this.transform.transform(tmpBuf, rgb);
                    AWTUtil.toBufferedImage((Picture)rgb, (BufferedImage)renderImage);
                    FrameRendererVisitor.this.kinesisVideoFrameViewer.update(renderImage);
                    FrameRendererVisitor.this.frameCount++;
                }
            }
        }
    }
}

