/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities;

import com.amazonaws.kinesisvideo.parser.ebml.EBMLTypeInfo;
import com.amazonaws.kinesisvideo.parser.mkv.MkvDataElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.MkvEndMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvStartMasterElement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MkvChildElementCollector
extends MkvElementVisitor {
    private static final Logger log = LoggerFactory.getLogger(MkvChildElementCollector.class);
    private final EBMLTypeInfo parentTypeInfo;
    private final List<MkvElement> collectedElements = new ArrayList<MkvElement>();

    public MkvChildElementCollector(EBMLTypeInfo parentTypeInfo) {
        Validate.isTrue((boolean)parentTypeInfo.getType().equals((Object)EBMLTypeInfo.TYPE.MASTER), (String)"ChildElementCollectors can only collect children for master elements", (Object[])new Object[0]);
        log.debug("MkvChildElementCollector for element {}", (Object)parentTypeInfo);
        this.parentTypeInfo = parentTypeInfo;
    }

    @Override
    public void visit(MkvStartMasterElement startMasterElement) {
        if (this.isParentType(startMasterElement) || this.shouldBeCollected(startMasterElement)) {
            log.debug("Add start master element {} to collector ", (Object)startMasterElement);
            this.collectedElements.add(startMasterElement);
        }
    }

    @Override
    public void visit(MkvEndMasterElement endMasterElement) {
        if (this.isParentType(endMasterElement) || this.shouldBeCollected(endMasterElement)) {
            log.debug("Add end master element {} to collector ", (Object)endMasterElement);
            this.collectedElements.add(endMasterElement);
        }
    }

    @Override
    public void visit(MkvDataElement dataElement) {
        if (this.shouldBeCollected(dataElement)) {
            log.debug("Copy value and add data element {}  to collector ", (Object)dataElement);
            dataElement.getValueCopy();
            this.collectedElements.add(dataElement);
        }
    }

    public List<MkvElement> copyOfCollection() {
        return new ArrayList<MkvElement>(this.collectedElements);
    }

    public void clearCollection() {
        this.collectedElements.clear();
    }

    public boolean equivalent(List<MkvElement> otherChildren) {
        if (this.collectedElements.size() != otherChildren.size()) {
            return false;
        }
        for (int i = 0; i < this.collectedElements.size(); ++i) {
            MkvElement collectedElement = this.collectedElements.get(i);
            MkvElement otherElement = otherChildren.get(i);
            if (!collectedElement.getClass().equals(otherElement.getClass())) {
                return false;
            }
            if (collectedElement.equivalent(otherElement)) continue;
            return false;
        }
        return true;
    }

    private boolean isParentType(MkvElement startMasterElement) {
        return startMasterElement.getElementMetaData().getTypeInfo().equals(this.parentTypeInfo);
    }

    private boolean shouldBeCollected(MkvElement mkvElement) {
        if (mkvElement.getElementPath().size() <= this.parentTypeInfo.getLevel()) {
            if (mkvElement.getElementMetaData().getTypeInfo().getLevel() > this.parentTypeInfo.getLevel()) {
                log.warn("Element {} has a path {} shorter than parent type's {} level but does not belong to a lower level than the parent ", new Object[]{mkvElement.getElementMetaData().toString(), mkvElement.getElementPath().size(), this.parentTypeInfo.toString()});
            }
            return false;
        }
        return mkvElement.getElementPath().get(this.parentTypeInfo.getLevel()).getTypeInfo().equals(this.parentTypeInfo);
    }

    public EBMLTypeInfo getParentTypeInfo() {
        return this.parentTypeInfo;
    }
}

