/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities;

import com.amazonaws.kinesisvideo.parser.ebml.EBMLTypeInfo;
import com.amazonaws.kinesisvideo.parser.ebml.MkvTypeInfos;
import com.amazonaws.kinesisvideo.parser.mkv.Frame;
import com.amazonaws.kinesisvideo.parser.mkv.MkvDataElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitException;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.MkvEndMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvStartMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.visitors.CompositeMkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.visitors.CountVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.MkvChildElementCollector;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputSegmentMerger
extends CompositeMkvElementVisitor {
    private static final Logger log = LoggerFactory.getLogger(OutputSegmentMerger.class);
    private final OutputStream outputStream;
    private final List<CollectorState> collectorStates;
    private final Configuration configuration;
    private MergeState state = MergeState.NEW;
    private final MergeVisitor mergeVisitor = new MergeVisitor();
    private final ByteArrayOutputStream bufferingSegmentStream = new ByteArrayOutputStream();
    private WritableByteChannel bufferingSegmentChannel;
    private final ByteArrayOutputStream bufferingClusterStream = new ByteArrayOutputStream();
    private WritableByteChannel bufferingClusterChannel;
    private final CountVisitor countVisitor;
    private final WritableByteChannel outputChannel;
    private long emittedSegments = 0L;
    private Optional<BigInteger> lastClusterTimecode = Optional.empty();
    private final List<Integer> clusterFrameTimeCodes = new ArrayList<Integer>();
    public static final List<EBMLTypeInfo> DEFAULT_MASTER_ELEMENTS_TO_MERGE_ON = ImmutableList.of((Object)MkvTypeInfos.TRACKS, (Object)MkvTypeInfos.EBML);
    private static final ByteBuffer SEGMENT_ELEMENT_WITH_UNKNOWN_LENGTH = ByteBuffer.wrap(new byte[]{24, 83, -128, 103, 1, -1, -1, -1, -1, -1, -1, -1});
    private static final ByteBuffer VOID_ELEMENT_WITH_SIZE_ONE = ByteBuffer.wrap(new byte[]{-20, -127, 66});

    private OutputSegmentMerger(OutputStream outputStream, CountVisitor countVisitor, Configuration configuration) {
        super(countVisitor);
        this.childVisitors.add(this.mergeVisitor);
        this.countVisitor = countVisitor;
        this.outputStream = outputStream;
        this.outputChannel = Channels.newChannel(this.outputStream);
        this.bufferingSegmentChannel = Channels.newChannel(this.bufferingSegmentStream);
        this.bufferingClusterChannel = Channels.newChannel(this.bufferingClusterStream);
        this.collectorStates = configuration.typeInfosToMergeOn.stream().map(CollectorState::new).collect(Collectors.toList());
        this.configuration = configuration;
    }

    public static OutputSegmentMerger create(OutputStream outputStream, Configuration configuration) {
        return new OutputSegmentMerger(outputStream, OutputSegmentMerger.getCountVisitor(), configuration);
    }

    public static OutputSegmentMerger createDefault(OutputStream outputStream) {
        return new OutputSegmentMerger(outputStream, OutputSegmentMerger.getCountVisitor(), Configuration.builder().build());
    }

    public static OutputSegmentMerger createToStopAtFirstNonMatchingSegment(OutputStream outputStream) {
        return new OutputSegmentMerger(outputStream, OutputSegmentMerger.getCountVisitor(), Configuration.builder().stopAtFirstNonMatchingSegment(true).build());
    }

    private static CountVisitor getCountVisitor() {
        return CountVisitor.create(MkvTypeInfos.CLUSTER, MkvTypeInfos.SEGMENT, MkvTypeInfos.SIMPLEBLOCK);
    }

    public int getClustersCount() {
        return this.countVisitor.getCount(MkvTypeInfos.CLUSTER);
    }

    public int getSegmentsCount() {
        return this.countVisitor.getCount(MkvTypeInfos.SEGMENT);
    }

    public int getSimpleBlocksCount() {
        return this.countVisitor.getCount(MkvTypeInfos.SIMPLEBLOCK);
    }

    @Override
    public boolean isDone() {
        return MergeState.DONE == this.state;
    }

    private void emitClusterStart() throws IOException {
        this.bufferingClusterChannel.close();
        int numBytes = this.outputChannel.write(ByteBuffer.wrap(this.bufferingClusterStream.toByteArray()));
        log.debug("Wrote buffered cluster start data to output stream {} bytes", (Object)numBytes);
    }

    private void emitAdjustedTimeCode(MkvDataElement timeCodeElement) throws MkvElementVisitException {
        if (this.configuration.packClusters) {
            BigInteger adjustedTimeCode;
            int dataSize = (int)timeCodeElement.getDataSize();
            if (this.lastClusterTimecode.isPresent()) {
                Collections.sort(this.clusterFrameTimeCodes);
                ArrayList<Integer> frameDurations = new ArrayList<Integer>();
                for (int i = 1; i < this.clusterFrameTimeCodes.size(); ++i) {
                    frameDurations.add(this.clusterFrameTimeCodes.get(i) - this.clusterFrameTimeCodes.get(i - 1));
                }
                int averageFrameDuration = frameDurations.isEmpty() ? 1 : frameDurations.stream().mapToInt(Integer::intValue).sum() / frameDurations.size();
                frameDurations.add(averageFrameDuration);
                int clusterDuration = frameDurations.stream().mapToInt(Integer::intValue).sum();
                adjustedTimeCode = this.lastClusterTimecode.get().add(BigInteger.valueOf(clusterDuration));
            } else {
                adjustedTimeCode = BigInteger.valueOf(0L);
            }
            byte[] newDataBytes = adjustedTimeCode.toByteArray();
            Validate.isTrue((dataSize >= newDataBytes.length ? 1 : 0) != 0, (String)"Adjusted timecode is not compatible with the existing data size", (Object[])new Object[0]);
            ByteBuffer newDataBuffer = ByteBuffer.allocate(dataSize);
            newDataBuffer.position(dataSize - newDataBytes.length);
            newDataBuffer.put(newDataBytes);
            newDataBuffer.rewind();
            MkvDataElement adjustedTimeCodeElement = MkvDataElement.builder().idAndSizeRawBytes(timeCodeElement.getIdAndSizeRawBytes()).elementMetaData(timeCodeElement.getElementMetaData()).elementPath(timeCodeElement.getElementPath()).dataSize(timeCodeElement.getDataSize()).dataBuffer(newDataBuffer).build();
            this.emit(adjustedTimeCodeElement);
            this.lastClusterTimecode = Optional.of(adjustedTimeCode);
            this.clusterFrameTimeCodes.clear();
        } else {
            this.emit(timeCodeElement);
            this.lastClusterTimecode = Optional.of((BigInteger)timeCodeElement.getValueCopy().getVal());
        }
    }

    private void emitFrame(MkvDataElement simpleBlockElement) throws MkvElementVisitException {
        if (this.configuration.packClusters) {
            Frame frame = (Frame)simpleBlockElement.getValueCopy().getVal();
            this.clusterFrameTimeCodes.add(frame.getTimeCode());
        }
        this.emit(simpleBlockElement);
    }

    private void bufferAndCollect(MkvStartMasterElement startMasterElement) throws IOException, MkvElementVisitException {
        Validate.isTrue((this.state == MergeState.BUFFERING_SEGMENT || this.state == MergeState.BUFFERING_CLUSTER_START ? 1 : 0) != 0, (String)("Trying to buffer in wrong state " + (Object)((Object)this.state)), (Object[])new Object[0]);
        if (MergeState.BUFFERING_SEGMENT == this.state) {
            if (!this.collectorStates.isEmpty() && MkvTypeInfos.SEGMENT.equals(startMasterElement.getElementMetaData().getTypeInfo()) && !startMasterElement.isUnknownLength()) {
                SEGMENT_ELEMENT_WITH_UNKNOWN_LENGTH.rewind();
                this.bufferingSegmentChannel.write(SEGMENT_ELEMENT_WITH_UNKNOWN_LENGTH);
            } else {
                startMasterElement.writeToChannel(this.bufferingSegmentChannel);
            }
        } else {
            startMasterElement.writeToChannel(this.bufferingClusterChannel);
        }
        this.sendElementToAllCollectors(startMasterElement);
    }

    private void bufferAndCollect(MkvDataElement dataElement) throws MkvElementVisitException {
        Validate.isTrue((this.state == MergeState.BUFFERING_SEGMENT || this.state == MergeState.BUFFERING_CLUSTER_START ? 1 : 0) != 0, (String)("Trying to buffer in wrong state " + (Object)((Object)this.state)), (Object[])new Object[0]);
        if (MergeState.BUFFERING_SEGMENT == this.state) {
            OutputSegmentMerger.writeToChannel(this.bufferingSegmentChannel, dataElement);
        } else {
            OutputSegmentMerger.writeToChannel(this.bufferingClusterChannel, dataElement);
        }
        this.sendElementToAllCollectors(dataElement);
    }

    private static void writeToChannel(WritableByteChannel byteChannel, MkvDataElement dataElement) throws MkvElementVisitException {
        dataElement.writeToChannel(byteChannel);
    }

    private void emit(MkvStartMasterElement startMasterElement) throws MkvElementVisitException {
        Validate.isTrue((this.state == MergeState.EMITTING ? 1 : 0) != 0, (String)("emitting in wrong state " + (Object)((Object)this.state)), (Object[])new Object[0]);
        startMasterElement.writeToChannel(this.outputChannel);
    }

    private void emit(MkvDataElement dataElement) throws MkvElementVisitException {
        Validate.isTrue((this.state == MergeState.EMITTING ? 1 : 0) != 0, (String)("emitting in wrong state " + (Object)((Object)this.state)), (Object[])new Object[0]);
        dataElement.writeToChannel(this.outputChannel);
    }

    private void collect(MkvEndMasterElement endMasterElement) throws MkvElementVisitException {
        this.sendElementToAllCollectors(endMasterElement);
    }

    private void sendElementToAllCollectors(MkvElement dataElement) throws MkvElementVisitException {
        for (CollectorState cs : this.collectorStates) {
            dataElement.accept(cs.getCollector());
        }
    }

    private void emitBufferedSegmentData(boolean shouldEmitSegmentData) throws IOException {
        this.bufferingSegmentChannel.close();
        if (shouldEmitSegmentData) {
            int numBytes = this.outputChannel.write(ByteBuffer.wrap(this.bufferingSegmentStream.toByteArray()));
            log.debug("Wrote buffered header data to output stream {} bytes", (Object)numBytes);
            ++this.emittedSegments;
        } else {
            VOID_ELEMENT_WITH_SIZE_ONE.rewind();
            this.outputChannel.write(VOID_ELEMENT_WITH_SIZE_ONE);
        }
    }

    private void resetChannels() {
        this.bufferingSegmentStream.reset();
        this.bufferingSegmentChannel = Channels.newChannel(this.bufferingSegmentStream);
        this.bufferingClusterStream.reset();
        this.bufferingClusterChannel = Channels.newChannel(this.bufferingClusterStream);
    }

    private boolean shouldEmitBufferedSegmentData() {
        boolean doAllCollectorsMatchPreviousResults = false;
        if (!this.collectorStates.isEmpty()) {
            doAllCollectorsMatchPreviousResults = this.collectorStates.stream().allMatch(CollectorState::doCurrentAndOldResultsMatch);
        }
        log.info("Number of collectors {}. Did all collectors match previous results: {} ", (Object)this.collectorStates.size(), (Object)doAllCollectorsMatchPreviousResults);
        return !doAllCollectorsMatchPreviousResults;
    }

    private void resetCollectors() {
        this.collectorStates.forEach(CollectorState::reset);
    }

    private static class CollectorState {
        private final EBMLTypeInfo parentTypeInfo;
        private final MkvChildElementCollector collector;
        private List<MkvElement> previousResult = new ArrayList<MkvElement>();

        public CollectorState(EBMLTypeInfo parentTypeInfo) {
            this.parentTypeInfo = parentTypeInfo;
            this.collector = new MkvChildElementCollector(parentTypeInfo);
        }

        public void reset() {
            this.previousResult = this.collector.copyOfCollection();
            this.collector.clearCollection();
        }

        boolean doCurrentAndOldResultsMatch() {
            return this.collector.equivalent(this.previousResult);
        }

        public EBMLTypeInfo getParentTypeInfo() {
            return this.parentTypeInfo;
        }

        public MkvChildElementCollector getCollector() {
            return this.collector;
        }
    }

    private class MergeVisitor
    extends MkvElementVisitor {
        private MergeVisitor() {
        }

        @Override
        public void visit(MkvStartMasterElement startMasterElement) throws MkvElementVisitException {
            try {
                switch (OutputSegmentMerger.this.state) {
                    case NEW: {
                        Validate.isTrue((boolean)MkvTypeInfos.EBML.equals(startMasterElement.getElementMetaData().getTypeInfo()), (String)"EBML should be the only expected element type when a new MKV stream is expected", (Object[])new Object[0]);
                        log.info("Detected start of EBML element, transitioning from {} to BUFFERING", (Object)OutputSegmentMerger.this.state);
                        OutputSegmentMerger.this.state = MergeState.BUFFERING_SEGMENT;
                        OutputSegmentMerger.this.bufferAndCollect(startMasterElement);
                        break;
                    }
                    case BUFFERING_SEGMENT: {
                        EBMLTypeInfo startElementTypeInfo = startMasterElement.getElementMetaData().getTypeInfo();
                        if (MkvTypeInfos.CLUSTER.equals(startElementTypeInfo) || MkvTypeInfos.TAGS.equals(startElementTypeInfo)) {
                            boolean shouldEmitSegment = OutputSegmentMerger.this.shouldEmitBufferedSegmentData();
                            if (shouldEmitSegment) {
                                if (OutputSegmentMerger.this.configuration.stopAtFirstNonMatchingSegment && OutputSegmentMerger.this.emittedSegments >= 1L) {
                                    log.info("Detected start of element {} transitioning from {} to DONE", (Object)startElementTypeInfo, (Object)OutputSegmentMerger.this.state);
                                    OutputSegmentMerger.this.state = MergeState.DONE;
                                    break;
                                }
                                OutputSegmentMerger.this.emitBufferedSegmentData(true);
                                OutputSegmentMerger.this.resetChannels();
                                log.info("Detected start of element {} transitioning from {} to EMITTING", (Object)startElementTypeInfo, (Object)OutputSegmentMerger.this.state);
                                OutputSegmentMerger.this.state = MergeState.EMITTING;
                                OutputSegmentMerger.this.emit(startMasterElement);
                                break;
                            }
                            log.info("Detected start of element {} transitioning from {} to BUFFERING_CLUSTER_START", (Object)startElementTypeInfo, (Object)OutputSegmentMerger.this.state);
                            OutputSegmentMerger.this.state = MergeState.BUFFERING_CLUSTER_START;
                            OutputSegmentMerger.this.bufferAndCollect(startMasterElement);
                            break;
                        }
                        OutputSegmentMerger.this.bufferAndCollect(startMasterElement);
                        break;
                    }
                    case BUFFERING_CLUSTER_START: {
                        OutputSegmentMerger.this.bufferAndCollect(startMasterElement);
                        break;
                    }
                    case EMITTING: {
                        OutputSegmentMerger.this.emit(startMasterElement);
                        break;
                    }
                    case DONE: {
                        log.warn("OutputSegmentMerger is already done. It will not process any more elements.");
                    }
                }
            }
            catch (IOException ie) {
                this.wrapIOException(ie);
            }
        }

        private void wrapIOException(IOException ie) throws MkvElementVisitException {
            String exceptionMessage = "IOException in merge visitor ";
            exceptionMessage = OutputSegmentMerger.this.lastClusterTimecode.isPresent() ? exceptionMessage + "in or immediately after cluster with timecode " + OutputSegmentMerger.this.lastClusterTimecode.get() : exceptionMessage + "in first cluster";
            throw new MkvElementVisitException(exceptionMessage, ie);
        }

        @Override
        public void visit(MkvEndMasterElement endMasterElement) throws MkvElementVisitException {
            switch (OutputSegmentMerger.this.state) {
                case NEW: {
                    Validate.isTrue((boolean)false, (String)("Should not start with an EndMasterElement " + endMasterElement.toString()), (Object[])new Object[0]);
                    break;
                }
                case BUFFERING_SEGMENT: 
                case BUFFERING_CLUSTER_START: {
                    OutputSegmentMerger.this.collect(endMasterElement);
                    break;
                }
                case EMITTING: {
                    if (!MkvTypeInfos.SEGMENT.equals(endMasterElement.getElementMetaData().getTypeInfo())) break;
                    log.info("Detected end of segment element, transitioning from {} to NEW", (Object)OutputSegmentMerger.this.state);
                    OutputSegmentMerger.this.state = MergeState.NEW;
                    OutputSegmentMerger.this.resetCollectors();
                    break;
                }
                case DONE: {
                    log.warn("OutputSegmentMerger is already done. It will not process any more elements.");
                }
            }
        }

        @Override
        public void visit(MkvDataElement dataElement) throws MkvElementVisitException {
            try {
                switch (OutputSegmentMerger.this.state) {
                    case NEW: {
                        Validate.isTrue((boolean)false, (String)("Should not start with a data element " + dataElement.toString()), (Object[])new Object[0]);
                        break;
                    }
                    case BUFFERING_SEGMENT: {
                        OutputSegmentMerger.this.bufferAndCollect(dataElement);
                        break;
                    }
                    case BUFFERING_CLUSTER_START: {
                        if (MkvTypeInfos.TIMECODE.equals(dataElement.getElementMetaData().getTypeInfo())) {
                            BigInteger currentTimeCode = (BigInteger)dataElement.getValueCopy().getVal();
                            if (OutputSegmentMerger.this.lastClusterTimecode.isPresent() && currentTimeCode.compareTo((BigInteger)OutputSegmentMerger.this.lastClusterTimecode.get()) <= 0) {
                                if (OutputSegmentMerger.this.configuration.stopAtFirstNonMatchingSegment && OutputSegmentMerger.this.emittedSegments >= 1L) {
                                    log.info("Detected time code going back from {} to {}, state from {} to DONE", new Object[]{OutputSegmentMerger.this.lastClusterTimecode, currentTimeCode, OutputSegmentMerger.this.state});
                                    OutputSegmentMerger.this.state = MergeState.DONE;
                                } else {
                                    OutputSegmentMerger.this.emitBufferedSegmentData(true);
                                }
                            }
                            if (!this.isDone()) {
                                OutputSegmentMerger.this.emitClusterStart();
                                OutputSegmentMerger.this.resetChannels();
                                OutputSegmentMerger.this.state = MergeState.EMITTING;
                                OutputSegmentMerger.this.emitAdjustedTimeCode(dataElement);
                            }
                            break;
                        }
                        OutputSegmentMerger.this.bufferAndCollect(dataElement);
                        break;
                    }
                    case EMITTING: {
                        if (MkvTypeInfos.TIMECODE.equals(dataElement.getElementMetaData().getTypeInfo())) {
                            OutputSegmentMerger.this.emitAdjustedTimeCode(dataElement);
                            break;
                        }
                        if (MkvTypeInfos.SIMPLEBLOCK.equals(dataElement.getElementMetaData().getTypeInfo())) {
                            OutputSegmentMerger.this.emitFrame(dataElement);
                            break;
                        }
                        OutputSegmentMerger.this.emit(dataElement);
                        break;
                    }
                    case DONE: {
                        log.warn("OutputSegmentMerger is already done. It will not process any more elements.");
                    }
                }
            }
            catch (IOException ie) {
                this.wrapIOException(ie);
            }
        }

        @Override
        public boolean isDone() {
            return MergeState.DONE == OutputSegmentMerger.this.state;
        }
    }

    public static class Configuration {
        private final boolean stopAtFirstNonMatchingSegment;
        private final boolean packClusters;
        private final List<EBMLTypeInfo> typeInfosToMergeOn;

        private static boolean $default$stopAtFirstNonMatchingSegment() {
            return false;
        }

        private static boolean $default$packClusters() {
            return false;
        }

        private static List<EBMLTypeInfo> $default$typeInfosToMergeOn() {
            return DEFAULT_MASTER_ELEMENTS_TO_MERGE_ON;
        }

        Configuration(boolean stopAtFirstNonMatchingSegment, boolean packClusters, List<EBMLTypeInfo> typeInfosToMergeOn) {
            this.stopAtFirstNonMatchingSegment = stopAtFirstNonMatchingSegment;
            this.packClusters = packClusters;
            this.typeInfosToMergeOn = typeInfosToMergeOn;
        }

        public static ConfigurationBuilder builder() {
            return new ConfigurationBuilder();
        }

        public static class ConfigurationBuilder {
            private boolean stopAtFirstNonMatchingSegment$set;
            private boolean stopAtFirstNonMatchingSegment$value;
            private boolean packClusters$set;
            private boolean packClusters$value;
            private boolean typeInfosToMergeOn$set;
            private List<EBMLTypeInfo> typeInfosToMergeOn$value;

            ConfigurationBuilder() {
            }

            public ConfigurationBuilder stopAtFirstNonMatchingSegment(boolean stopAtFirstNonMatchingSegment) {
                this.stopAtFirstNonMatchingSegment$value = stopAtFirstNonMatchingSegment;
                this.stopAtFirstNonMatchingSegment$set = true;
                return this;
            }

            public ConfigurationBuilder packClusters(boolean packClusters) {
                this.packClusters$value = packClusters;
                this.packClusters$set = true;
                return this;
            }

            public ConfigurationBuilder typeInfosToMergeOn(List<EBMLTypeInfo> typeInfosToMergeOn) {
                this.typeInfosToMergeOn$value = typeInfosToMergeOn;
                this.typeInfosToMergeOn$set = true;
                return this;
            }

            public Configuration build() {
                boolean stopAtFirstNonMatchingSegment$value = this.stopAtFirstNonMatchingSegment$value;
                if (!this.stopAtFirstNonMatchingSegment$set) {
                    stopAtFirstNonMatchingSegment$value = Configuration.$default$stopAtFirstNonMatchingSegment();
                }
                boolean packClusters$value = this.packClusters$value;
                if (!this.packClusters$set) {
                    packClusters$value = Configuration.$default$packClusters();
                }
                List typeInfosToMergeOn$value = this.typeInfosToMergeOn$value;
                if (!this.typeInfosToMergeOn$set) {
                    typeInfosToMergeOn$value = Configuration.$default$typeInfosToMergeOn();
                }
                return new Configuration(stopAtFirstNonMatchingSegment$value, packClusters$value, typeInfosToMergeOn$value);
            }

            public String toString() {
                return "OutputSegmentMerger.Configuration.ConfigurationBuilder(stopAtFirstNonMatchingSegment$value=" + this.stopAtFirstNonMatchingSegment$value + ", packClusters$value=" + this.packClusters$value + ", typeInfosToMergeOn$value=" + this.typeInfosToMergeOn$value + ")";
            }
        }
    }

    static enum MergeState {
        NEW,
        BUFFERING_SEGMENT,
        BUFFERING_CLUSTER_START,
        EMITTING,
        DONE;

    }
}

