/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.ebml;

import com.amazonaws.kinesisvideo.parser.ebml.EBMLElementMetaData;
import com.amazonaws.kinesisvideo.parser.ebml.EBMLParserCallbacks;
import com.amazonaws.kinesisvideo.parser.ebml.EBMLParserInternalElement;
import com.amazonaws.kinesisvideo.parser.ebml.EBMLTypeInfo;
import com.amazonaws.kinesisvideo.parser.ebml.EBMLTypeInfoProvider;
import com.amazonaws.kinesisvideo.parser.ebml.ParserBulkByteSource;
import com.amazonaws.kinesisvideo.parser.ebml.ParserByteSource;
import com.amazonaws.kinesisvideo.parser.ebml.ReplayIdAndSizeBuffer;
import com.amazonaws.kinesisvideo.parser.ebml.TrackingReplayableIdAndSizeByteSource;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBMLParser {
    private static final Logger log = LoggerFactory.getLogger(EBMLParser.class);
    private static final int BYTE_MASK = 255;
    private static final int DEFAULT_MAX_CONTENT_BYTES_IN_ONE_PASS = 8192;
    private final EBMLTypeInfoProvider typeInfoProvider;
    private final Stack<EBMLParserInternalElement> masterElements;
    private final EBMLParserCallbacks callbacks;
    private final int maxContentBytesInOnePass;
    private final ByteBuffer skipBuffer;
    private long elementCount = 0L;
    private long totalBytesRead = 0L;
    private boolean endOfStream;
    private boolean closed;
    private EBMLParserInternalElement currentElement;
    private ReplayIdAndSizeBuffer replayIdAndSizeBuffer;

    public EBMLParser(EBMLTypeInfoProvider typeInfoProvider, EBMLParserCallbacks callbacks) {
        this(typeInfoProvider, callbacks, 8192);
    }

    public EBMLParser(EBMLTypeInfoProvider typeInfoProvider, EBMLParserCallbacks callbacks, int maxContentBytesInOnePass) {
        this.typeInfoProvider = typeInfoProvider;
        this.callbacks = callbacks;
        this.replayIdAndSizeBuffer = new ReplayIdAndSizeBuffer(12);
        this.createNewCurrentElementInfo();
        this.masterElements = new Stack();
        this.maxContentBytesInOnePass = maxContentBytesInOnePass;
        this.skipBuffer = ByteBuffer.allocate(maxContentBytesInOnePass);
        log.debug("Creating EBMLParser with maxContentBytesInOnePass {}", (Object)this.maxContentBytesInOnePass);
    }

    public void parse(ParserByteSource byteSource) {
        try (CallState callState = new CallState(byteSource);){
            block13: while (callState.shouldContinueParsing()) {
                if (log.isDebugEnabled()) {
                    log.debug("Current element read state {}", (Object)this.currentElement.currentElementReadState);
                }
                switch (this.currentElement.currentElementReadState) {
                    case NEW: {
                        this.removeMasterElementsBasedOnSizeEnd();
                        this.currentElement.readId(callState);
                        continue block13;
                    }
                    case ID_DONE: {
                        this.currentElement.readSize(callState);
                        continue block13;
                    }
                    case SIZE_DONE: {
                        this.currentElement.updateTypeInfo(this.typeInfoProvider);
                        this.removeMasterElementsBasedOnLevel();
                        if (this.currentElement.isKnownType()) {
                            log.debug("Invoking onStartElement for current element {}", (Object)this.currentElement);
                            this.callbacks.onStartElement(this.currentElement.getMetadata(), this.currentElement.getDataSize(), this.replayIdAndSizeBuffer.getByteBuffer(), this::currentElementPath);
                        }
                        this.startReadingContentBasedOnType();
                        continue block13;
                    }
                    case CONTENT_READING: {
                        Validate.isTrue((boolean)this.currentElement.isKnownType(), (String)"We should read only from elements with known types", (Object[])new Object[0]);
                        this.currentElement.readContent(callState, callState, this.callbacks, this.maxContentBytesInOnePass);
                        continue block13;
                    }
                    case CONTENT_SKIPPING: {
                        Validate.isTrue((!this.currentElement.isKnownType() ? 1 : 0) != 0, (String)"We should skip data for unknown elements only", (Object[])new Object[0]);
                        this.skipBuffer.rewind();
                        this.currentElement.skipContent(callState, callState, this.skipBuffer);
                        continue block13;
                    }
                    case FINISHED: {
                        this.invokeOnEndElementCallback(this.currentElement);
                        this.removeMasterElementsBasedOnSizeEnd();
                        this.createNewCurrentElementInfo();
                        continue block13;
                    }
                }
                throw new IllegalArgumentException("Unexpected ElementReadState");
            }
            log.debug("Stopping parsing");
            if (this.endOfStream) {
                this.closeParser();
            }
        }
    }

    public void closeParser() {
        if (!this.closed) {
            log.debug("Closing EBMLParser");
            if (this.currentElement != null && this.currentElement.isKnownType()) {
                log.debug("Closing with currentElement {} still set, invoking end element callback on it", (Object)this.currentElement);
                this.invokeOnEndElementCallback(this.currentElement);
                this.currentElement = null;
            }
            log.debug("Closing with {} master elements on stack, invoking end element callback on them", (Object)this.masterElements.size());
            while (!this.masterElements.isEmpty()) {
                EBMLParserInternalElement top = this.masterElements.pop();
                this.invokeOnEndElementCallback(top);
            }
        }
        this.closed = true;
    }

    private void startReadingContentBasedOnType() {
        if (!this.currentElement.isKnownType()) {
            Validate.isTrue((!this.currentElement.isUnknownLength() ? 1 : 0) != 0, (String)"Cannot skip element of unknown length", (Object[])new Object[0]);
            this.currentElement.startSkippingContent();
            log.warn("Will skip content for element number {} with unknown id {} datasize {}", new Object[]{this.currentElement.getElementCount(), this.currentElement.getId(), this.currentElement.getDataSize()});
        } else if (this.currentElement.getTypeInfo().getType() == EBMLTypeInfo.TYPE.MASTER) {
            this.currentElement.startReadingContent();
            this.masterElements.push(this.currentElement);
            this.createNewCurrentElementInfo();
        } else {
            Validate.isTrue((!this.currentElement.isUnknownLength() ? 1 : 0) != 0, (String)"A non-master element should not have unknown length", (Object[])new Object[0]);
            this.currentElement.startReadingContent();
        }
    }

    private void removeMasterElementsBasedOnLevel() {
        if (!this.currentElement.isKnownType()) {
            return;
        }
        if (!this.currentElement.getTypeInfo().isGlobal()) {
            while (!this.masterElements.isEmpty()) {
                EBMLParserInternalElement top = this.masterElements.peek();
                Validate.isTrue((this.currentElement.getElementCount() != top.getElementCount() ? 1 : 0) != 0);
                if (this.currentElement.getTypeInfo().getLevel() > top.getTypeInfo().getLevel()) break;
                log.debug("Removing master element {} based on level of current element {}", (Object)top, (Object)this.currentElement);
                this.masterElements.pop();
                this.invokeOnEndElementCallback(top);
            }
        }
    }

    private void removeMasterElementsBasedOnSizeEnd() {
        EBMLParserInternalElement top;
        if (!this.currentElement.isKnownType()) {
            return;
        }
        while (!this.masterElements.isEmpty() && !(top = this.masterElements.peek()).isUnknownLength() && top.endOffSet() <= this.totalBytesRead) {
            log.debug("Removing master element {} based on size end {}", (Object)top, (Object)this.totalBytesRead);
            this.masterElements.pop();
            this.invokeOnEndElementCallback(top);
        }
    }

    private List<EBMLElementMetaData> currentElementPath() {
        return this.masterElements.stream().map(EBMLParserInternalElement::getMetadata).collect(Collectors.toList());
    }

    private void invokeOnEndElementCallback(EBMLParserInternalElement finishedElement) {
        if (finishedElement.isKnownType()) {
            log.debug("Invoking onStartElement for current element {}", (Object)finishedElement);
            this.callbacks.onEndElement(finishedElement.getMetadata(), this::currentElementPath);
        }
    }

    private void createNewCurrentElementInfo() {
        this.currentElement = new EBMLParserInternalElement(this.totalBytesRead, this.elementCount);
        ++this.elementCount;
        this.replayIdAndSizeBuffer.init(this.totalBytesRead);
    }

    boolean isEndOfStream() {
        return this.endOfStream;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private class CallState
    implements Closeable,
    TrackingReplayableIdAndSizeByteSource,
    ParserBulkByteSource {
        private boolean parseMore = true;
        private final ParserByteSource byteSource;
        private long readOffsetForReplayBuffer;

        @Override
        public long getTotalBytesRead() {
            return EBMLParser.this.totalBytesRead;
        }

        @Override
        public void close() {
        }

        boolean shouldContinueParsing() {
            return !EBMLParser.this.endOfStream && this.parseMore && EBMLParser.this.callbacks.continueParsing();
        }

        @Override
        public boolean checkAndReadIntoReplayBuffer(int len) {
            if (this.parseMore) {
                int availableInReplayBuffer = EBMLParser.this.replayIdAndSizeBuffer.availableAfter(this.readOffsetForReplayBuffer);
                Validate.isTrue((availableInReplayBuffer >= 0 ? 1 : 0) != 0);
                if (availableInReplayBuffer >= len) {
                    return true;
                }
                int numBytesToRead = len - availableInReplayBuffer;
                this.parseMore = this.byteSource.available() >= numBytesToRead;
                numBytesToRead = Math.min(numBytesToRead, this.byteSource.available());
                for (int i = 0; i < numBytesToRead; ++i) {
                    this.readFromByteSourceIntoReplayBuffer();
                }
            }
            return this.parseMore;
        }

        @Override
        public int readByte() {
            if (EBMLParser.this.replayIdAndSizeBuffer.inReplayBuffer(this.readOffsetForReplayBuffer)) {
                byte result = EBMLParser.this.replayIdAndSizeBuffer.getByteFromOffset(this.readOffsetForReplayBuffer);
                ++this.readOffsetForReplayBuffer;
                return result & 0xFF;
            }
            int result = this.readFromByteSourceIntoReplayBuffer();
            ++this.readOffsetForReplayBuffer;
            return result;
        }

        private int readFromByteSourceIntoReplayBuffer() {
            int result = this.byteSource.readByte();
            if (result == -1) {
                this.markAsEndofStream();
                return -1;
            }
            Validate.inclusiveBetween((long)0L, (long)255L, (long)result);
            EBMLParser.this.replayIdAndSizeBuffer.addByte((byte)result);
            EBMLParser.this.totalBytesRead++;
            return result;
        }

        @Override
        public int availableForContent() {
            if (this.parseMore) {
                int availableBytes = this.byteSource.available();
                if (availableBytes == 0) {
                    this.parseMore = false;
                }
                return availableBytes;
            }
            return 0;
        }

        @Override
        public int readBytes(ByteBuffer dest, int numBytes) {
            int readBytes = this.byteSource.readBytes(dest, numBytes);
            if (readBytes == -1) {
                this.markAsEndofStream();
                return readBytes;
            }
            Validate.isTrue((readBytes >= 0 ? 1 : 0) != 0);
            EBMLParser.this.totalBytesRead += readBytes;
            return readBytes;
        }

        private void markAsEndofStream() {
            EBMLParser.this.endOfStream = true;
            this.parseMore = false;
        }

        public CallState(ParserByteSource byteSource) {
            this.byteSource = byteSource;
        }

        @Override
        public void setReadOffsetForReplayBuffer(long readOffsetForReplayBuffer) {
            this.readOffsetForReplayBuffer = readOffsetForReplayBuffer;
        }
    }
}

