/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.ebml;

import com.amazonaws.kinesisvideo.parser.ebml.TrackingReplayableIdAndSizeByteSource;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.Validate;

public class EBMLUtils {
    public static final long UNKNOWN_LENGTH_VALUE = -1L;
    public static final int EBML_ID_MAX_BYTES = 4;
    public static final int EBML_SIZE_MAX_BYTES = 8;
    private static final int BYTE_MASK = 255;
    private static final int BYTE_WITH_FIRST_BIT_SET = 128;

    private EBMLUtils() {
    }

    static void readId(TrackingReplayableIdAndSizeByteSource source, IdConsumer resultAcceptor) {
        if (!EBMLUtils.isEnoughBytes(source, 1)) {
            return;
        }
        int firstByte = EBMLUtils.readByte(source);
        if (firstByte == -1) {
            resultAcceptor.accept(firstByte, 1L);
        }
        Validate.isTrue((firstByte >= 0 ? 1 : 0) != 0, (String)("EBML Id has negative firstByte" + firstByte), (Object[])new Object[0]);
        int numAdditionalBytes = EBMLUtils.getNumLeadingZeros(firstByte);
        if (!EBMLUtils.isEnoughBytes(source, numAdditionalBytes)) {
            return;
        }
        Validate.isTrue((numAdditionalBytes <= 3 ? 1 : 0) != 0, (String)("Trying to decode an EBML ID and it wants " + numAdditionalBytes + " more bytes, but IDs max out at 4 bytes. firstByte was " + firstByte), (Object[])new Object[0]);
        int rest = (int)EBMLUtils.readEbmlValueNumber(source, numAdditionalBytes);
        resultAcceptor.accept(firstByte << numAdditionalBytes * 8 | rest, numAdditionalBytes + 1);
    }

    private static void readEbmlInt(TrackingReplayableIdAndSizeByteSource source, SizeConsumer resultAcceptor) {
        if (!EBMLUtils.isEnoughBytes(source, 1)) {
            return;
        }
        int firstByte = EBMLUtils.readByte(source);
        Validate.isTrue((firstByte >= 0 ? 1 : 0) != 0, (String)("EBML Int has negative firstByte" + firstByte), (Object[])new Object[0]);
        int size = EBMLUtils.getNumLeadingZeros(firstByte);
        if (!EBMLUtils.isEnoughBytes(source, size)) {
            return;
        }
        long rest = EBMLUtils.readEbmlValueNumber(source, size);
        long value = (long)((firstByte & ~(-128 >> size)) << size * 8) | rest;
        long unknownValue = 255 >> size + 1;
        unknownValue <<= size * 8;
        if (value == (unknownValue |= (1L << size * 8) - 1L)) {
            value = -1L;
        }
        resultAcceptor.accept(value, size + 1);
    }

    public static long readEbmlInt(ByteBuffer byteBuffer) {
        int firstByte = byteBuffer.get() & 0xFF;
        Validate.isTrue((firstByte >= 0 ? 1 : 0) != 0, (String)("EBML Int has negative firstByte" + firstByte), (Object[])new Object[0]);
        int size = EBMLUtils.getNumLeadingZeros(firstByte);
        long rest = EBMLUtils.readUnsignedIntegerSevenBytesOrLess(byteBuffer, size);
        return (long)((firstByte & ~(-128 >> size)) << size * 8) | rest;
    }

    static void readSize(TrackingReplayableIdAndSizeByteSource source, SizeConsumer resultAcceptor) {
        EBMLUtils.readEbmlInt(source, resultAcceptor);
    }

    private static int readByte(TrackingReplayableIdAndSizeByteSource source) {
        return source.readByte() & 0xFF;
    }

    private static boolean isEnoughBytes(TrackingReplayableIdAndSizeByteSource source, int len) {
        return source.checkAndReadIntoReplayBuffer(len);
    }

    private static int getNumLeadingZeros(int b) {
        return Integer.numberOfLeadingZeros(b) - 24;
    }

    private static long readEbmlValueNumber(TrackingReplayableIdAndSizeByteSource source, long size) {
        Validate.inclusiveBetween((long)0L, (long)8L, (long)size, (String)("Asked for a numeric value of invalid size " + size));
        Validate.isTrue((boolean)EBMLUtils.isEnoughBytes(source, (int)size));
        long value = 0L;
        int i = 0;
        while ((long)i < size) {
            int result = EBMLUtils.readByte(source);
            value = value << 8 | (long)result;
            ++i;
        }
        return value;
    }

    public static long readUnsignedIntegerSevenBytesOrLess(ByteBuffer byteBuffer, long size) {
        Validate.inclusiveBetween((long)0L, (long)7L, (long)size, (String)("Asked for a numeric value of invalid size " + size));
        Validate.isTrue(((long)byteBuffer.remaining() >= size ? 1 : 0) != 0);
        long value = 0L;
        int i = 0;
        while ((long)i < size) {
            int result = byteBuffer.get() & 0xFF;
            value = value << 8 | (long)result;
            ++i;
        }
        return value;
    }

    public static long readDataSignedInteger(ByteBuffer byteBuffer, long size) {
        Validate.inclusiveBetween((long)0L, (long)8L, (long)size, (String)("Asked for a numeric value of invalid size " + size));
        Validate.isTrue(((long)byteBuffer.remaining() >= size ? 1 : 0) != 0);
        long value = 0L;
        int i = 0;
        while ((long)i < size) {
            int result = byteBuffer.get() & 0xFF;
            if (i == 0) {
                boolean positive;
                boolean bl = positive = (result & 0x80) == 0;
                if (!positive) {
                    value = -1L;
                }
            }
            value = value << 8 | (long)result;
            ++i;
        }
        return value;
    }

    public static BigInteger readDataUnsignedInteger(ByteBuffer byteBuffer, long size) {
        Validate.inclusiveBetween((long)0L, (long)8L, (long)size, (String)("Asked for a numeric value of invalid size " + size));
        Validate.isTrue(((long)byteBuffer.remaining() >= size ? 1 : 0) != 0);
        byte[] byteArray = new byte[(int)size];
        byteBuffer.get(byteArray);
        return new BigInteger(1, byteArray);
    }

    @FunctionalInterface
    static interface SizeConsumer {
        public void accept(long var1, long var3);
    }

    @FunctionalInterface
    static interface IdConsumer {
        public void accept(int var1, long var2);
    }
}

