/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.ebml;

import com.amazonaws.kinesisvideo.parser.ebml.ParserByteSource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.Validate;

public class InputStreamParserByteSource
implements ParserByteSource {
    private static final int BUFFER_SIZE = 8192;
    private static final int MARK_SIZE = 100;
    private final BufferedInputStream bufferedInputStream;

    public InputStreamParserByteSource(InputStream inputStream) {
        this(inputStream, 8192);
    }

    InputStreamParserByteSource(InputStream inputStream, int bufferSize) {
        this.bufferedInputStream = new BufferedInputStream(inputStream, bufferSize);
        Validate.isTrue((boolean)this.bufferedInputStream.markSupported());
    }

    @Override
    public int readByte() {
        try {
            return this.bufferedInputStream.read();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while reading byte from input stream!", e);
        }
    }

    @Override
    public int available() {
        try {
            return this.bufferedInputStream.available();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while getting available bytes from input stream!", e);
        }
    }

    @Override
    public int readBytes(ByteBuffer dest, int numBytes) {
        try {
            Validate.isTrue((dest.remaining() >= numBytes ? 1 : 0) != 0);
            int numBytesRead = this.bufferedInputStream.read(dest.array(), dest.position(), numBytes);
            if (numBytesRead > 0) {
                dest.position(dest.position() + numBytesRead);
            }
            return numBytesRead;
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while reading bytes from input stream!", e);
        }
    }

    @Override
    public boolean eof() {
        try {
            this.bufferedInputStream.mark(100);
            if (this.readByte() == -1) {
                return true;
            }
            this.bufferedInputStream.reset();
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while resetting input stream!", e);
        }
    }
}

