/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.ebml;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.Validate;

class ReplayIdAndSizeBuffer {
    private int count;
    private final byte[] buffer;
    private long startingOffset;

    ReplayIdAndSizeBuffer(int length) {
        this.buffer = new byte[length];
    }

    void init(long startingOffset) {
        this.startingOffset = startingOffset;
        this.count = 0;
    }

    void addByte(byte val) {
        Validate.isTrue((this.count < this.buffer.length ? 1 : 0) != 0, (String)("Too many bytes being added to replay buffer " + this.count), (Object[])new Object[0]);
        this.buffer[this.count] = val;
        ++this.count;
    }

    boolean inReplayBuffer(long readOffset) {
        return readOffset - this.startingOffset < (long)this.count;
    }

    int availableAfter(long readOffset) {
        return (int)Math.max(0L, this.startingOffset + (long)this.count - readOffset);
    }

    byte getByteFromOffset(long readOffset) {
        Validate.isTrue((boolean)this.inReplayBuffer(readOffset), (String)("Attempt to read from replay buffer at " + readOffset + "while buffer starts at" + this.startingOffset + "and has " + this.count + "bytes"), (Object[])new Object[0]);
        return this.buffer[(int)(readOffset - this.startingOffset)];
    }

    ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap(this.buffer, 0, this.count);
    }
}

