/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.examples;

import com.amazonaws.kinesisvideo.parser.examples.ImagePanel;
import com.amazonaws.kinesisvideo.parser.rekognition.pojo.BoundingBox;
import com.amazonaws.kinesisvideo.parser.rekognition.pojo.FaceType;
import com.amazonaws.kinesisvideo.parser.rekognition.pojo.MatchedFace;
import com.amazonaws.kinesisvideo.parser.rekognition.pojo.RekognizedOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundingBoxImagePanel
extends ImagePanel {
    private static final Logger log = LoggerFactory.getLogger(BoundingBoxImagePanel.class);
    private static final String DELIMITER = "-";

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void processRekognitionOutput(Graphics2D g2, int width, int height, RekognizedOutput rekognizedOutput) {
        if (rekognizedOutput != null && rekognizedOutput.getFaceSearchOutputs() != null) {
            log.debug("Number of detected faces in a frame {}", (Object)rekognizedOutput.getFaceSearchOutputs().size());
            for (RekognizedOutput.FaceSearchOutput faceSearchOutput : rekognizedOutput.getFaceSearchOutputs()) {
                FaceType detectedFaceType;
                String title;
                if (!faceSearchOutput.getMatchedFaceList().isEmpty()) {
                    MatchedFace matchedFace = faceSearchOutput.getMatchedFaceList().get(0);
                    String externalImageId = matchedFace.getFace().getExternalImageId();
                    if (externalImageId == null) {
                        title = matchedFace.getFace().getConfidence() + "";
                        detectedFaceType = FaceType.NOT_RECOGNIZED;
                    } else {
                        String[] imageIds = externalImageId.split(DELIMITER);
                        if (imageIds.length > 1) {
                            title = imageIds[0];
                            detectedFaceType = FaceType.fromString(imageIds[1]);
                        } else {
                            title = "No prefix";
                            detectedFaceType = FaceType.NOT_RECOGNIZED;
                        }
                    }
                    log.debug("Number of matched faces for the detected face {}", (Object)faceSearchOutput.getMatchedFaceList().size());
                } else {
                    detectedFaceType = FaceType.NOT_RECOGNIZED;
                    title = "Not recognized";
                }
                this.drawFaces(g2, width, height, faceSearchOutput.getDetectedFace().getBoundingBox(), title, detectedFaceType.getColor());
            }
        }
    }

    private void drawFaces(Graphics2D g2, int width, int height, BoundingBox boundingBox, String personName, Color color) {
        Color c = g2.getColor();
        g2.setColor(color);
        this.drawBoundingBox(g2, width, height, boundingBox);
        this.drawFaceTitle(g2, width, height, boundingBox, personName);
        g2.setColor(c);
    }

    private void drawFaceTitle(Graphics2D g2, int width, int height, BoundingBox boundingBox, String personName) {
        int left = (int)(boundingBox.getLeft() * (double)width);
        int top = (int)(boundingBox.getTop() * (double)height);
        g2.drawString(personName, left, top);
    }

    private void drawBoundingBox(Graphics2D g2, int width, int height, BoundingBox boundingBox) {
        int left = (int)(boundingBox.getLeft() * (double)width);
        int top = (int)(boundingBox.getTop() * (double)height);
        int bbWidth = (int)(boundingBox.getWidth() * (double)width);
        int bbHeight = (int)(boundingBox.getHeight() * (double)height);
        g2.drawRect(left, top, bbWidth, bbHeight);
    }

    public void setImage(BufferedImage bufferedImage, RekognizedOutput rekognizedOutput) {
        this.image = bufferedImage;
        this.processRekognitionOutput(this.image.createGraphics(), this.image.getWidth(), this.image.getHeight(), rekognizedOutput);
        this.repaint();
    }
}

