/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.examples;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.kinesisvideo.parser.ebml.MkvTypeInfos;
import com.amazonaws.kinesisvideo.parser.examples.GetMediaWorker;
import com.amazonaws.kinesisvideo.parser.examples.KinesisVideoCommon;
import com.amazonaws.kinesisvideo.parser.examples.PutMediaWorker;
import com.amazonaws.kinesisvideo.parser.examples.StreamOps;
import com.amazonaws.kinesisvideo.parser.mkv.MkvDataElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitException;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.MkvEndMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvStartMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.visitors.CompositeMkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.FragmentMetadataVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.OutputSegmentMerger;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideo;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoClientBuilder;
import com.amazonaws.services.kinesisvideo.model.StartSelector;
import com.amazonaws.services.kinesisvideo.model.StartSelectorType;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KinesisVideoExample
extends KinesisVideoCommon {
    private static final Logger log = LoggerFactory.getLogger(KinesisVideoExample.class);
    private static final long SLEEP_PERIOD_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    private static final int DATA_RETENTION_IN_HOURS = 48;
    private final AmazonKinesisVideo amazonKinesisVideo;
    private final InputStream inputStream;
    private final ExecutorService executorService;
    private PutMediaWorker putMediaWorker;
    private final StreamOps streamOps;
    private GetMediaProcessingArguments getMediaProcessingArguments;
    private boolean noSampleInputRequired = false;

    private KinesisVideoExample(Regions region, String streamName, AWSCredentialsProvider credentialsProvider, InputStream inputVideoStream, boolean noSampleInputRequired) {
        super(region, credentialsProvider, streamName);
        AmazonKinesisVideoClientBuilder builder = AmazonKinesisVideoClientBuilder.standard();
        this.configureClient((AwsClientBuilder)builder);
        this.amazonKinesisVideo = (AmazonKinesisVideo)builder.build();
        this.inputStream = inputVideoStream;
        this.streamOps = new StreamOps(region, streamName, credentialsProvider);
        this.executorService = Executors.newFixedThreadPool(2);
        this.noSampleInputRequired = noSampleInputRequired;
    }

    public void execute() throws InterruptedException, IOException {
        this.streamOps.createStreamIfNotExist();
        try (GetMediaProcessingArguments getMediaProcessingArgumentsLocal = this.getMediaProcessingArguments = GetMediaProcessingArguments.create();){
            GetMediaWorker getMediaWorker = GetMediaWorker.create(this.getRegion(), this.getCredentialsProvider(), this.getStreamName(), new StartSelector().withStartSelectorType(StartSelectorType.NOW), this.amazonKinesisVideo, getMediaProcessingArgumentsLocal.getMkvElementVisitor());
            this.executorService.submit(getMediaWorker);
            if (!this.noSampleInputRequired) {
                this.putMediaWorker = PutMediaWorker.create(this.getRegion(), this.getCredentialsProvider(), this.getStreamName(), this.inputStream, this.amazonKinesisVideo);
                this.executorService.submit(this.putMediaWorker);
            }
            this.executorService.shutdown();
            this.executorService.awaitTermination(120L, TimeUnit.SECONDS);
            if (!this.executorService.isTerminated()) {
                log.warn("Shutting down executor service by force");
                this.executorService.shutdownNow();
            } else {
                log.info("Executor service is shutdown");
            }
        }
    }

    public long getFragmentsPersisted() {
        return this.putMediaWorker.getNumFragmentsPersisted();
    }

    public long getFragmentsRead() {
        return this.getMediaProcessingArguments.getFragmentCount();
    }

    public static KinesisVideoExampleBuilder builder() {
        return new KinesisVideoExampleBuilder();
    }

    public static class KinesisVideoExampleBuilder {
        private Regions region;
        private String streamName;
        private AWSCredentialsProvider credentialsProvider;
        private InputStream inputVideoStream;
        private boolean noSampleInputRequired;

        KinesisVideoExampleBuilder() {
        }

        public KinesisVideoExampleBuilder region(Regions region) {
            this.region = region;
            return this;
        }

        public KinesisVideoExampleBuilder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public KinesisVideoExampleBuilder credentialsProvider(AWSCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public KinesisVideoExampleBuilder inputVideoStream(InputStream inputVideoStream) {
            this.inputVideoStream = inputVideoStream;
            return this;
        }

        public KinesisVideoExampleBuilder noSampleInputRequired(boolean noSampleInputRequired) {
            this.noSampleInputRequired = noSampleInputRequired;
            return this;
        }

        public KinesisVideoExample build() {
            return new KinesisVideoExample(this.region, this.streamName, this.credentialsProvider, this.inputVideoStream, this.noSampleInputRequired);
        }

        public String toString() {
            return "KinesisVideoExample.KinesisVideoExampleBuilder(region=" + this.region + ", streamName=" + this.streamName + ", credentialsProvider=" + this.credentialsProvider + ", inputVideoStream=" + this.inputVideoStream + ", noSampleInputRequired=" + this.noSampleInputRequired + ")";
        }
    }

    private static class GetMediaProcessingArguments
    implements Closeable {
        private final BufferedOutputStream outputStream;
        private final LogVisitor logVisitor;
        private final CompositeMkvElementVisitor mkvElementVisitor;

        public GetMediaProcessingArguments(BufferedOutputStream outputStream, LogVisitor logVisitor, CompositeMkvElementVisitor mkvElementVisitor) {
            this.outputStream = outputStream;
            this.mkvElementVisitor = mkvElementVisitor;
            this.logVisitor = logVisitor;
        }

        public static GetMediaProcessingArguments create() throws IOException {
            FragmentMetadataVisitor fragmentMetadataVisitor = FragmentMetadataVisitor.create();
            LogVisitor logVisitor = new LogVisitor(fragmentMetadataVisitor);
            OutputStream fileOutputStream = Files.newOutputStream(Paths.get("kinesis_video_example_merged_output2.mkv", new String[0]), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
            OutputSegmentMerger outputSegmentMerger = OutputSegmentMerger.createDefault(outputStream);
            CompositeMkvElementVisitor mkvElementVisitor = new CompositeMkvElementVisitor(fragmentMetadataVisitor, outputSegmentMerger, logVisitor);
            return new GetMediaProcessingArguments(outputStream, logVisitor, mkvElementVisitor);
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }

        public long getFragmentCount() {
            return this.logVisitor.fragmentCount;
        }

        public CompositeMkvElementVisitor getMkvElementVisitor() {
            return this.mkvElementVisitor;
        }
    }

    private static class LogVisitor
    extends MkvElementVisitor {
        private final FragmentMetadataVisitor fragmentMetadataVisitor;
        private long fragmentCount = 0L;

        @Override
        public void visit(MkvStartMasterElement startMasterElement) throws MkvElementVisitException {
            if (MkvTypeInfos.EBML.equals(startMasterElement.getElementMetaData().getTypeInfo())) {
                ++this.fragmentCount;
                log.info("Start of segment  {} ", (Object)this.fragmentCount);
            }
        }

        @Override
        public void visit(MkvEndMasterElement endMasterElement) throws MkvElementVisitException {
            if (MkvTypeInfos.SEGMENT.equals(endMasterElement.getElementMetaData().getTypeInfo())) {
                log.info("End of segment  {} fragment # {} millisBehindNow {} ", new Object[]{this.fragmentCount, this.fragmentMetadataVisitor.getCurrentFragmentMetadata().get().getFragmentNumberString(), this.fragmentMetadataVisitor.getMillisBehindNow().getAsLong()});
            }
        }

        @Override
        public void visit(MkvDataElement dataElement) throws MkvElementVisitException {
        }

        public LogVisitor(FragmentMetadataVisitor fragmentMetadataVisitor) {
            this.fragmentMetadataVisitor = fragmentMetadataVisitor;
        }

        public long getFragmentCount() {
            return this.fragmentCount;
        }
    }
}

