/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.examples;

import com.amazonaws.kinesisvideo.parser.examples.ImagePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

public class KinesisVideoFrameViewer
extends JFrame {
    private final int width;
    private final int height;
    private final String title;
    protected ImagePanel panel;

    protected KinesisVideoFrameViewer(int width, int height, String title) {
        this.width = width;
        this.height = height;
        this.title = title;
        this.setTitle(title);
        this.setBackground(Color.BLACK);
    }

    public KinesisVideoFrameViewer(int width, int height) {
        this(width, height, "Kinesis Video Frame Viewer ");
        this.panel = new ImagePanel();
        this.addImagePanel(this.panel);
    }

    protected void addImagePanel(ImagePanel panel) {
        panel.setPreferredSize(new Dimension(this.width, this.height));
        this.add(panel);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.out.println(KinesisVideoFrameViewer.this.title + " closed");
                System.exit(0);
            }
        });
    }

    public void update(BufferedImage image) {
        this.panel.setImage(image);
    }
}

