/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.examples;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.kinesisvideo.parser.examples.GetMediaWorker;
import com.amazonaws.kinesisvideo.parser.examples.KinesisVideoCommon;
import com.amazonaws.kinesisvideo.parser.examples.KinesisVideoFrameViewer;
import com.amazonaws.kinesisvideo.parser.examples.PutMediaWorker;
import com.amazonaws.kinesisvideo.parser.examples.StreamOps;
import com.amazonaws.kinesisvideo.parser.utilities.FragmentMetadataVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.FrameVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.H264FrameRenderer;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesisvideo.model.StartSelector;
import com.amazonaws.services.kinesisvideo.model.StartSelectorType;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KinesisVideoRendererExample
extends KinesisVideoCommon {
    private static final Logger log = LoggerFactory.getLogger(KinesisVideoRendererExample.class);
    private static final int FRAME_WIDTH = 640;
    private static final int FRAME_HEIGHT = 480;
    private final InputStream inputStream;
    private final StreamOps streamOps;
    private final ExecutorService executorService;
    private GetMediaProcessingArguments getMediaProcessingArguments;
    private boolean renderFragmentMetadata = true;
    private boolean noSampleInputRequired = false;

    private KinesisVideoRendererExample(Regions region, String streamName, AWSCredentialsProvider credentialsProvider, InputStream inputVideoStream, boolean renderFragmentMetadata, boolean noSampleInputRequired) {
        super(region, credentialsProvider, streamName);
        this.inputStream = inputVideoStream;
        this.streamOps = new StreamOps(region, streamName, credentialsProvider);
        this.executorService = Executors.newFixedThreadPool(2);
        this.renderFragmentMetadata = renderFragmentMetadata;
        this.noSampleInputRequired = noSampleInputRequired;
    }

    public void execute() throws InterruptedException, IOException {
        this.streamOps.createStreamIfNotExist();
        try (GetMediaProcessingArguments getMediaProcessingArgumentsLocal = this.getMediaProcessingArguments = GetMediaProcessingArguments.create(this.renderFragmentMetadata ? Optional.of(new FragmentMetadataVisitor.BasicMkvTagProcessor()) : Optional.empty());){
            if (!this.noSampleInputRequired) {
                PutMediaWorker putMediaWorker = PutMediaWorker.create(this.getRegion(), this.getCredentialsProvider(), this.getStreamName(), this.inputStream, this.streamOps.amazonKinesisVideo);
                this.executorService.submit(putMediaWorker);
            }
            GetMediaWorker getMediaWorker = GetMediaWorker.create(this.getRegion(), this.getCredentialsProvider(), this.getStreamName(), new StartSelector().withStartSelectorType(StartSelectorType.NOW), this.streamOps.amazonKinesisVideo, getMediaProcessingArgumentsLocal.getFrameVisitor());
            this.executorService.submit(getMediaWorker);
            this.executorService.shutdown();
            this.executorService.awaitTermination(180L, TimeUnit.SECONDS);
            if (!this.executorService.isTerminated()) {
                log.warn("Shutting down executor service by force");
                this.executorService.shutdownNow();
            } else {
                log.info("Executor service is shutdown");
            }
        }
    }

    public static KinesisVideoRendererExampleBuilder builder() {
        return new KinesisVideoRendererExampleBuilder();
    }

    public static class KinesisVideoRendererExampleBuilder {
        private Regions region;
        private String streamName;
        private AWSCredentialsProvider credentialsProvider;
        private InputStream inputVideoStream;
        private boolean renderFragmentMetadata;
        private boolean noSampleInputRequired;

        KinesisVideoRendererExampleBuilder() {
        }

        public KinesisVideoRendererExampleBuilder region(Regions region) {
            this.region = region;
            return this;
        }

        public KinesisVideoRendererExampleBuilder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public KinesisVideoRendererExampleBuilder credentialsProvider(AWSCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public KinesisVideoRendererExampleBuilder inputVideoStream(InputStream inputVideoStream) {
            this.inputVideoStream = inputVideoStream;
            return this;
        }

        public KinesisVideoRendererExampleBuilder renderFragmentMetadata(boolean renderFragmentMetadata) {
            this.renderFragmentMetadata = renderFragmentMetadata;
            return this;
        }

        public KinesisVideoRendererExampleBuilder noSampleInputRequired(boolean noSampleInputRequired) {
            this.noSampleInputRequired = noSampleInputRequired;
            return this;
        }

        public KinesisVideoRendererExample build() {
            return new KinesisVideoRendererExample(this.region, this.streamName, this.credentialsProvider, this.inputVideoStream, this.renderFragmentMetadata, this.noSampleInputRequired);
        }

        public String toString() {
            return "KinesisVideoRendererExample.KinesisVideoRendererExampleBuilder(region=" + this.region + ", streamName=" + this.streamName + ", credentialsProvider=" + this.credentialsProvider + ", inputVideoStream=" + this.inputVideoStream + ", renderFragmentMetadata=" + this.renderFragmentMetadata + ", noSampleInputRequired=" + this.noSampleInputRequired + ")";
        }
    }

    private static class GetMediaProcessingArguments
    implements Closeable {
        private final FrameVisitor frameVisitor;

        GetMediaProcessingArguments(FrameVisitor frameVisitor) {
            this.frameVisitor = frameVisitor;
        }

        private static GetMediaProcessingArguments create(Optional<FragmentMetadataVisitor.MkvTagProcessor> tagProcessor) throws IOException {
            KinesisVideoFrameViewer kinesisVideoFrameViewer = new KinesisVideoFrameViewer(640, 480);
            return new GetMediaProcessingArguments(FrameVisitor.create(H264FrameRenderer.create(kinesisVideoFrameViewer), tagProcessor, Optional.of(1L)));
        }

        @Override
        public void close() throws IOException {
        }

        public FrameVisitor getFrameVisitor() {
            return this.frameVisitor;
        }
    }
}

