/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.examples;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.kinesisvideo.parser.examples.KinesisVideoCommon;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideo;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoClientBuilder;
import com.amazonaws.services.kinesisvideo.model.CreateStreamRequest;
import com.amazonaws.services.kinesisvideo.model.DeleteStreamRequest;
import com.amazonaws.services.kinesisvideo.model.DescribeStreamRequest;
import com.amazonaws.services.kinesisvideo.model.ResourceNotFoundException;
import com.amazonaws.services.kinesisvideo.model.StreamInfo;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamOps
extends KinesisVideoCommon {
    private static final Logger log = LoggerFactory.getLogger(StreamOps.class);
    private static final long SLEEP_PERIOD_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    private static final int DATA_RETENTION_IN_HOURS = 48;
    private final String streamName;
    final AmazonKinesisVideo amazonKinesisVideo;

    public StreamOps(Regions region, String streamName, AWSCredentialsProvider credentialsProvider) {
        super(region, credentialsProvider, streamName);
        this.streamName = streamName;
        AmazonKinesisVideoClientBuilder builder = AmazonKinesisVideoClientBuilder.standard();
        this.configureClient((AwsClientBuilder)builder);
        this.amazonKinesisVideo = (AmazonKinesisVideo)builder.build();
    }

    public void recreateStreamIfNecessary() throws InterruptedException {
        this.deleteStreamIfPresent();
        this.amazonKinesisVideo.createStream(new CreateStreamRequest().withStreamName(this.streamName).withDataRetentionInHours(Integer.valueOf(48)).withMediaType("video/h264"));
        log.info("CreateStream called for stream {}", (Object)this.streamName);
        Optional<StreamInfo> createdStreamInfo = this.waitForStateToMatch(s -> s.isPresent() && "ACTIVE".equals(((StreamInfo)s.get()).getStatus()));
        Validate.isTrue((boolean)createdStreamInfo.isPresent());
        Validate.isTrue((createdStreamInfo.get().getDataRetentionInHours() == 48 ? 1 : 0) != 0);
        log.info("Stream {} created ARN {}", (Object)this.streamName, (Object)createdStreamInfo.get().getStreamARN());
    }

    public void createStreamIfNotExist() throws InterruptedException {
        Optional<StreamInfo> streamInfo = this.getStreamInfo();
        log.info("Stream {} exists {}", (Object)this.streamName, (Object)streamInfo.isPresent());
        if (!streamInfo.isPresent()) {
            this.amazonKinesisVideo.createStream(new CreateStreamRequest().withStreamName(this.streamName).withDataRetentionInHours(Integer.valueOf(48)).withMediaType("video/h264"));
            log.info("CreateStream called for stream {}", (Object)this.streamName);
            Optional<StreamInfo> createdStreamInfo = this.waitForStateToMatch(s -> s.isPresent() && "ACTIVE".equals(((StreamInfo)s.get()).getStatus()));
            Validate.isTrue((boolean)createdStreamInfo.isPresent());
            Validate.isTrue((createdStreamInfo.get().getDataRetentionInHours() == 48 ? 1 : 0) != 0);
            log.info("Stream {} created ARN {}", (Object)this.streamName, (Object)createdStreamInfo.get().getStreamARN());
        }
    }

    private void deleteStreamIfPresent() throws InterruptedException {
        Optional<StreamInfo> streamInfo = this.getStreamInfo();
        log.info("Stream {} exists {}", (Object)this.streamName, (Object)streamInfo.isPresent());
        if (streamInfo.isPresent()) {
            this.amazonKinesisVideo.deleteStream(new DeleteStreamRequest().withStreamARN(streamInfo.get().getStreamARN()));
            log.info("DeleteStream called for stream {} ARN {} ", (Object)this.streamName, (Object)streamInfo.get().getStreamARN());
            this.waitForStateToMatch(s -> !s.isPresent());
            log.info("Stream {} deleted", (Object)this.streamName);
        }
    }

    private Optional<StreamInfo> waitForStateToMatch(Predicate<Optional<StreamInfo>> statePredicate) throws InterruptedException {
        Optional<StreamInfo> streamInfo;
        do {
            if (statePredicate.test(streamInfo = this.getStreamInfo())) continue;
            Thread.sleep(SLEEP_PERIOD_MILLIS);
        } while (!statePredicate.test(streamInfo));
        return streamInfo;
    }

    private Optional<StreamInfo> getStreamInfo() {
        try {
            return Optional.ofNullable(this.amazonKinesisVideo.describeStream(new DescribeStreamRequest().withStreamName(this.streamName)).getStreamInfo());
        }
        catch (ResourceNotFoundException e) {
            return Optional.empty();
        }
    }

    public static StreamOpsBuilder builder() {
        return new StreamOpsBuilder();
    }

    @Override
    public String getStreamName() {
        return this.streamName;
    }

    public AmazonKinesisVideo getAmazonKinesisVideo() {
        return this.amazonKinesisVideo;
    }

    public static class StreamOpsBuilder {
        private Regions region;
        private String streamName;
        private AWSCredentialsProvider credentialsProvider;

        StreamOpsBuilder() {
        }

        public StreamOpsBuilder region(Regions region) {
            this.region = region;
            return this;
        }

        public StreamOpsBuilder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public StreamOpsBuilder credentialsProvider(AWSCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public StreamOps build() {
            return new StreamOps(this.region, this.streamName, this.credentialsProvider);
        }

        public String toString() {
            return "StreamOps.StreamOpsBuilder(region=" + this.region + ", streamName=" + this.streamName + ", credentialsProvider=" + this.credentialsProvider + ")";
        }
    }
}

