/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.examples.lambda;

import java.nio.ByteBuffer;

public class EncodedFrame {
    private final ByteBuffer byteBuffer;
    private final ByteBuffer cpd;
    private final boolean isKeyFrame;
    private long timeCode;

    EncodedFrame(ByteBuffer byteBuffer, ByteBuffer cpd, boolean isKeyFrame, long timeCode) {
        this.byteBuffer = byteBuffer;
        this.cpd = cpd;
        this.isKeyFrame = isKeyFrame;
        this.timeCode = timeCode;
    }

    public static EncodedFrameBuilder builder() {
        return new EncodedFrameBuilder();
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public ByteBuffer getCpd() {
        return this.cpd;
    }

    public boolean isKeyFrame() {
        return this.isKeyFrame;
    }

    public long getTimeCode() {
        return this.timeCode;
    }

    public void setTimeCode(long timeCode) {
        this.timeCode = timeCode;
    }

    public static class EncodedFrameBuilder {
        private ByteBuffer byteBuffer;
        private ByteBuffer cpd;
        private boolean isKeyFrame;
        private long timeCode;

        EncodedFrameBuilder() {
        }

        public EncodedFrameBuilder byteBuffer(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
            return this;
        }

        public EncodedFrameBuilder cpd(ByteBuffer cpd) {
            this.cpd = cpd;
            return this;
        }

        public EncodedFrameBuilder isKeyFrame(boolean isKeyFrame) {
            this.isKeyFrame = isKeyFrame;
            return this;
        }

        public EncodedFrameBuilder timeCode(long timeCode) {
            this.timeCode = timeCode;
            return this;
        }

        public EncodedFrame build() {
            return new EncodedFrame(this.byteBuffer, this.cpd, this.isKeyFrame, this.timeCode);
        }

        public String toString() {
            return "EncodedFrame.EncodedFrameBuilder(byteBuffer=" + this.byteBuffer + ", cpd=" + this.cpd + ", isKeyFrame=" + this.isKeyFrame + ", timeCode=" + this.timeCode + ")";
        }
    }
}

