/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.examples.lambda;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.kinesisvideo.client.KinesisVideoClient;
import com.amazonaws.kinesisvideo.client.mediasource.CameraMediaSourceConfiguration;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSource;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSourceConfiguration;
import com.amazonaws.kinesisvideo.java.client.KinesisVideoJavaClientFactory;
import com.amazonaws.kinesisvideo.parser.examples.BoundingBoxImagePanel;
import com.amazonaws.kinesisvideo.parser.examples.lambda.EncodedFrame;
import com.amazonaws.kinesisvideo.parser.examples.lambda.KVSMediaSource;
import com.amazonaws.kinesisvideo.parser.mkv.Frame;
import com.amazonaws.kinesisvideo.parser.mkv.FrameProcessException;
import com.amazonaws.kinesisvideo.parser.rekognition.pojo.RekognizedOutput;
import com.amazonaws.kinesisvideo.parser.utilities.FragmentMetadata;
import com.amazonaws.kinesisvideo.parser.utilities.FrameVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.H264FrameDecoder;
import com.amazonaws.kinesisvideo.parser.utilities.H264FrameEncoder;
import com.amazonaws.kinesisvideo.parser.utilities.MkvTrackMetadata;
import com.amazonaws.kinesisvideo.parser.utilities.ProducerStreamUtil;
import com.amazonaws.kinesisvideo.producer.StreamInfo;
import com.amazonaws.regions.Regions;
import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H264FrameProcessor
implements FrameVisitor.FrameProcessor {
    private static final Logger log = LoggerFactory.getLogger(H264FrameProcessor.class);
    private static final int VIDEO_TRACK_NO = 1;
    private static final int MILLIS_IN_SEC = 1000;
    private static final int OFFSET_DELTA_THRESHOLD = 10;
    private final BoundingBoxImagePanel boundingBoxImagePanel = new BoundingBoxImagePanel();
    private final Regions regionName;
    private RekognizedOutput currentRekognizedOutput = null;
    private H264FrameEncoder h264Encoder;
    private H264FrameDecoder h264Decoder;
    private KVSMediaSource KVSMediaSource;
    private boolean isKVSProducerInitialized = false;
    private boolean isEncoderInitialized = false;
    private final AWSCredentialsProvider credentialsProvider;
    private final String outputKvsStreamName;
    private List<RekognizedOutput> rekognizedOutputs;
    private int frameBitRate = 1024;
    private int frameNo = 0;
    private int currentWidth = 0;
    private int currentHeight = 0;
    private long keyFrameTimecode;

    private H264FrameProcessor(AWSCredentialsProvider credentialsProvider, String outputKvsStreamName, Regions regionName) {
        this.credentialsProvider = credentialsProvider;
        this.outputKvsStreamName = outputKvsStreamName;
        this.regionName = regionName;
        this.h264Decoder = new H264FrameDecoder();
    }

    private void initializeKinesisVideoProducer(int width, int height, byte[] cpd) {
        try {
            log.info("Initializing KVS Producer with stream name {} and region : {}", (Object)this.outputKvsStreamName, (Object)this.regionName);
            KinesisVideoClient kinesisVideoClient = KinesisVideoJavaClientFactory.createKinesisVideoClient((Regions)this.regionName, (AWSCredentialsProvider)this.credentialsProvider);
            CameraMediaSourceConfiguration configuration = new CameraMediaSourceConfiguration.Builder().withFrameRate(30).withRetentionPeriodInHours(1).withCameraId("/dev/video0").withIsEncoderHardwareAccelerated(false).withEncodingMimeType("video/avc").withNalAdaptationFlags(StreamInfo.NalAdaptationFlags.NAL_ADAPTATION_ANNEXB_NALS).withIsAbsoluteTimecode(true).withEncodingBitRate(200000).withHorizontalResolution(width).withVerticalResolution(height).withCodecPrivateData(cpd).build();
            this.KVSMediaSource = new KVSMediaSource(ProducerStreamUtil.toStreamInfo(this.outputKvsStreamName, (MediaSourceConfiguration)configuration));
            this.KVSMediaSource.configure((MediaSourceConfiguration)configuration);
            kinesisVideoClient.registerMediaSource((MediaSource)this.KVSMediaSource);
        }
        catch (KinesisVideoException e) {
            log.error("Exception while initialize KVS Producer !", (Throwable)e);
        }
    }

    public void resetEncoder() {
        if (!this.isEncoderInitialized) {
            throw new IllegalStateException("Encoder not initialized !");
        }
        this.frameNo = 0;
        this.h264Encoder.setFrameNumber(this.frameNo);
    }

    public static H264FrameProcessor create(AWSCredentialsProvider credentialsProvider, String rekognizedStreamName, Regions regionName) {
        return new H264FrameProcessor(credentialsProvider, rekognizedStreamName, regionName);
    }

    @Override
    public void process(Frame frame, MkvTrackMetadata trackMetadata, Optional<FragmentMetadata> fragmentMetadata) throws FrameProcessException {
        if (this.rekognizedOutputs != null) {
            if (frame.getTrackNumber() == 1L) {
                Preconditions.checkState((trackMetadata.getPixelWidth().isPresent() && trackMetadata.getPixelHeight().isPresent() ? 1 : 0) != 0, (Object)"Missing video resolution in track metadata !");
                Preconditions.checkState((boolean)fragmentMetadata.isPresent(), (Object)"FragmentMetadata should be present !");
                BufferedImage decodedFrame = this.h264Decoder.decodeH264Frame(frame, trackMetadata);
                log.debug("Decoded frame : {} with timecode : {} and fragment metadata : {}", new Object[]{this.frameNo, frame.getTimeCode(), fragmentMetadata.get()});
                Optional<RekognizedOutput> rekognizedOutput = this.findRekognizedOutputForFrame(frame, fragmentMetadata);
                BufferedImage compositeFrame = this.renderFrame(decodedFrame, rekognizedOutput);
                EncodedFrame encodedH264Frame = this.encodeH264Frame(compositeFrame);
                encodedH264Frame.setTimeCode(fragmentMetadata.get().getProducerSideTimestampMillis() + (long)frame.getTimeCode());
                log.debug("Encoded frame : {} with timecode : {}", (Object)this.frameNo, (Object)encodedH264Frame.getTimeCode());
                this.putFrame(encodedH264Frame, trackMetadata.getPixelWidth().get().intValue(), trackMetadata.getPixelHeight().get().intValue());
                ++this.frameNo;
            } else {
                log.debug("Skipping audio frames !");
            }
        } else {
            log.warn("Rekognition output is empty");
        }
    }

    private void putFrame(EncodedFrame encodedH264Frame, int width, int height) {
        if (!this.isKVSProducerInitialized) {
            log.info("Initializing JNI...");
            this.initializeKinesisVideoProducer(width, height, encodedH264Frame.getCpd().array());
            this.isKVSProducerInitialized = true;
        }
        this.KVSMediaSource.putFrameData(encodedH264Frame);
        log.debug("PutFrame successful for frame no : {}", (Object)this.frameNo);
    }

    private EncodedFrame encodeH264Frame(BufferedImage bufferedImage) {
        try {
            this.initializeEncoder(bufferedImage);
            return this.h264Encoder.encodeFrame(bufferedImage);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to encode the bufferedImage !", e);
        }
    }

    private void initializeEncoder(BufferedImage bufferedImage) {
        if (!this.isEncoderInitialized || this.currentWidth != bufferedImage.getWidth() || this.currentHeight != bufferedImage.getHeight()) {
            this.h264Encoder = new H264FrameEncoder(bufferedImage.getWidth(), bufferedImage.getHeight(), this.frameBitRate);
            this.isEncoderInitialized = true;
            this.currentWidth = bufferedImage.getWidth();
            this.currentHeight = bufferedImage.getHeight();
        }
    }

    private Optional<RekognizedOutput> findRekognizedOutputForFrame(Frame frame, Optional<FragmentMetadata> fragmentMetadata) {
        Optional<RekognizedOutput> rekognizedOutput = Optional.empty();
        if (fragmentMetadata.isPresent()) {
            String fragmentNumber = fragmentMetadata.get().getFragmentNumberString();
            if (frame.isKeyFrame()) {
                this.keyFrameTimecode = frame.getTimeCode();
                log.debug("Key frame timecode : {}", (Object)this.keyFrameTimecode);
            }
            long frameOffset = (long)frame.getTimeCode() > this.keyFrameTimecode ? (long)frame.getTimeCode() - this.keyFrameTimecode : 0L;
            log.debug("Current Fragment Number : {} Computed Frame offset : {}", (Object)fragmentNumber, (Object)frameOffset);
            if (log.isDebugEnabled()) {
                this.rekognizedOutputs.forEach(p -> log.debug("frameOffsetInSeconds from Rekognition : {}", (Object)p.getFrameOffsetInSeconds()));
            }
            if ((rekognizedOutput = this.rekognizedOutputs.stream().filter(p -> this.isOffsetDeltaWithinThreshold(frameOffset, (RekognizedOutput)p)).findFirst()).isPresent()) {
                log.debug("Computed offset matched with retrieved offset. Delta : {}", (Object)Math.abs((double)frameOffset - rekognizedOutput.get().getFrameOffsetInSeconds() * 1000.0));
                if (this.rekognizedOutputs.isEmpty()) {
                    log.debug("All frames processed for this fragment number : {}", (Object)fragmentNumber);
                }
            }
        }
        return rekognizedOutput;
    }

    private boolean isOffsetDeltaWithinThreshold(long frameOffset, RekognizedOutput output) {
        return Math.abs((double)frameOffset - output.getFrameOffsetInSeconds() * 1000.0) <= 10.0;
    }

    private BufferedImage renderFrame(BufferedImage bufferedImage, Optional<RekognizedOutput> rekognizedOutput) {
        if (rekognizedOutput.isPresent()) {
            log.debug("Rendering Rekognized sampled frame...");
            this.boundingBoxImagePanel.processRekognitionOutput(bufferedImage.createGraphics(), bufferedImage.getWidth(), bufferedImage.getHeight(), rekognizedOutput.get());
            this.currentRekognizedOutput = rekognizedOutput.get();
        } else if (this.currentRekognizedOutput != null) {
            log.debug("Rendering non-sampled frame with previous rekognized results...");
            this.boundingBoxImagePanel.processRekognitionOutput(bufferedImage.createGraphics(), bufferedImage.getWidth(), bufferedImage.getHeight(), this.currentRekognizedOutput);
        } else {
            log.debug("Rendering frame without any rekognized results...");
        }
        return bufferedImage;
    }

    public void setRekognizedOutputs(List<RekognizedOutput> rekognizedOutputs) {
        this.rekognizedOutputs = rekognizedOutputs;
    }

    public void setFrameBitRate(int frameBitRate) {
        this.frameBitRate = frameBitRate;
    }
}

