/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.kinesis;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.kinesisvideo.parser.kinesis.KinesisRecordProcessor;
import com.amazonaws.kinesisvideo.parser.rekognition.pojo.RekognizedFragmentsIndex;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import java.net.InetAddress;
import java.util.UUID;

public final class KinesisDataStreamsWorker
implements Runnable {
    private static final String APPLICATION_NAME = "rekognition-kds-stream-application";
    private static final InitialPositionInStream SAMPLE_APPLICATION_INITIAL_POSITION_IN_STREAM = InitialPositionInStream.LATEST;
    private final Regions region;
    private final AWSCredentialsProvider credentialsProvider;
    private final String kdsStreamName;
    private final RekognizedFragmentsIndex rekognizedFragmentsIndex;

    public static KinesisDataStreamsWorker create(Regions region, AWSCredentialsProvider credentialsProvider, String kdsStreamName, RekognizedFragmentsIndex rekognizedFragmentsIndex) {
        return new KinesisDataStreamsWorker(region, credentialsProvider, kdsStreamName, rekognizedFragmentsIndex);
    }

    @Override
    public void run() {
        try {
            String workerId = InetAddress.getLocalHost().getCanonicalHostName() + ":" + UUID.randomUUID();
            KinesisClientLibConfiguration kinesisClientLibConfiguration = new KinesisClientLibConfiguration(APPLICATION_NAME, this.kdsStreamName, this.credentialsProvider, workerId);
            kinesisClientLibConfiguration.withInitialPositionInStream(SAMPLE_APPLICATION_INITIAL_POSITION_IN_STREAM).withRegionName(this.region.getName());
            IRecordProcessorFactory recordProcessorFactory = () -> new KinesisRecordProcessor(this.rekognizedFragmentsIndex, this.credentialsProvider);
            Worker worker = new Worker(recordProcessorFactory, kinesisClientLibConfiguration);
            System.out.printf("Running %s to process stream %s as worker %s...", APPLICATION_NAME, this.kdsStreamName, workerId);
            int exitCode = 0;
            try {
                worker.run();
            }
            catch (Throwable t) {
                System.err.println("Caught throwable while processing data.");
                t.printStackTrace();
                exitCode = 1;
            }
            System.out.println("Exit code : " + exitCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private KinesisDataStreamsWorker(Regions region, AWSCredentialsProvider credentialsProvider, String kdsStreamName, RekognizedFragmentsIndex rekognizedFragmentsIndex) {
        this.region = region;
        this.credentialsProvider = credentialsProvider;
        this.kdsStreamName = kdsStreamName;
        this.rekognizedFragmentsIndex = rekognizedFragmentsIndex;
    }
}

