/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.mkv;

import com.amazonaws.kinesisvideo.parser.ebml.EBMLElementMetaData;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitException;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;

public class MkvStartMasterElement
extends MkvElement {
    private final long dataSize;
    private final ByteBuffer idAndSizeRawBytes = ByteBuffer.allocate(12);

    private MkvStartMasterElement(EBMLElementMetaData elementMetaData, List<EBMLElementMetaData> elementPath, long dataSize, ByteBuffer idAndSizeRawBytes) {
        super(elementMetaData, elementPath);
        this.dataSize = dataSize;
        this.idAndSizeRawBytes.put(idAndSizeRawBytes);
        this.idAndSizeRawBytes.flip();
        idAndSizeRawBytes.rewind();
    }

    @Override
    public boolean isMaster() {
        return true;
    }

    @Override
    public void accept(MkvElementVisitor visitor) throws MkvElementVisitException {
        visitor.visit(this);
    }

    @Override
    public boolean equivalent(MkvElement other) {
        return this.typeEquals(other) && this.dataSize == ((MkvStartMasterElement)other).dataSize;
    }

    public boolean isUnknownLength() {
        return this.dataSize == -1L;
    }

    @Override
    public void writeToChannel(WritableByteChannel outputChannel) throws MkvElementVisitException {
        this.writeByteBufferToChannel(this.idAndSizeRawBytes, outputChannel);
    }

    public int getIdAndSizeRawBytesLength() {
        return this.idAndSizeRawBytes.limit();
    }

    public static MkvStartMasterElementBuilder builder() {
        return new MkvStartMasterElementBuilder();
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public ByteBuffer getIdAndSizeRawBytes() {
        return this.idAndSizeRawBytes;
    }

    @Override
    public String toString() {
        return "MkvStartMasterElement(super=" + super.toString() + ", dataSize=" + this.getDataSize() + ")";
    }

    public static class MkvStartMasterElementBuilder {
        private EBMLElementMetaData elementMetaData;
        private List<EBMLElementMetaData> elementPath;
        private long dataSize;
        private ByteBuffer idAndSizeRawBytes;

        MkvStartMasterElementBuilder() {
        }

        public MkvStartMasterElementBuilder elementMetaData(EBMLElementMetaData elementMetaData) {
            this.elementMetaData = elementMetaData;
            return this;
        }

        public MkvStartMasterElementBuilder elementPath(List<EBMLElementMetaData> elementPath) {
            this.elementPath = elementPath;
            return this;
        }

        public MkvStartMasterElementBuilder dataSize(long dataSize) {
            this.dataSize = dataSize;
            return this;
        }

        public MkvStartMasterElementBuilder idAndSizeRawBytes(ByteBuffer idAndSizeRawBytes) {
            this.idAndSizeRawBytes = idAndSizeRawBytes;
            return this;
        }

        public MkvStartMasterElement build() {
            return new MkvStartMasterElement(this.elementMetaData, this.elementPath, this.dataSize, this.idAndSizeRawBytes);
        }

        public String toString() {
            return "MkvStartMasterElement.MkvStartMasterElementBuilder(elementMetaData=" + this.elementMetaData + ", elementPath=" + this.elementPath + ", dataSize=" + this.dataSize + ", idAndSizeRawBytes=" + this.idAndSizeRawBytes + ")";
        }
    }
}

