/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.rekognition.pojo;

import com.amazonaws.kinesisvideo.parser.rekognition.pojo.RekognizedOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RekognizedFragmentsIndex {
    private static final Logger log = LoggerFactory.getLogger(RekognizedFragmentsIndex.class);
    private final ConcurrentHashMap<String, RekognizedFragment> rekognizedOutputMap = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<RekognizedFragment> rekognizedOutputQueue = new ConcurrentLinkedQueue();

    public synchronized void add(String fragmentNumber, Long producerTime, Long serverTime, RekognizedOutput rekognizedOutput) {
        if (this.rekognizedOutputMap.containsKey(fragmentNumber)) {
            RekognizedFragment rekognizedFragment = this.rekognizedOutputMap.get(fragmentNumber);
            rekognizedFragment.addRekognizedOutput(rekognizedOutput);
        } else {
            RekognizedFragment rekognizedFragment = new RekognizedFragment(fragmentNumber, producerTime, serverTime);
            rekognizedFragment.addRekognizedOutput(rekognizedOutput);
            this.rekognizedOutputQueue.add(rekognizedFragment);
            this.rekognizedOutputMap.put(fragmentNumber, rekognizedFragment);
        }
        log.debug("Added rekognized fragment number {} to the index.", (Object)fragmentNumber);
    }

    public synchronized RekognizedFragment poll() {
        RekognizedFragment rekognizedFragment = this.rekognizedOutputQueue.poll();
        this.rekognizedOutputMap.remove(rekognizedFragment.getFragmentNumber());
        return rekognizedFragment;
    }

    public int size() {
        log.debug("Rekognized index Map size : {} queue size : {}", (Object)this.rekognizedOutputMap.size(), (Object)this.rekognizedOutputQueue.size());
        if (this.rekognizedOutputMap.size() != this.rekognizedOutputQueue.size()) {
            throw new IllegalStateException("RekognizedFragmentsIndex map and queue size doesn't match");
        }
        return this.rekognizedOutputQueue.size();
    }

    public synchronized boolean isEmpty() {
        return this.rekognizedOutputQueue.isEmpty();
    }

    public synchronized List<RekognizedOutput> getRekognizedOutputList(String fragmentNumber) {
        return this.rekognizedOutputMap.containsKey(fragmentNumber) ? this.rekognizedOutputMap.get(fragmentNumber).getRekognizedOutputs() : null;
    }

    public synchronized void remove(String fragmentNumber) {
        if (this.rekognizedOutputMap.containsKey(fragmentNumber)) {
            RekognizedFragment rekognizedFragment = this.rekognizedOutputMap.remove(fragmentNumber);
            this.rekognizedOutputQueue.remove(rekognizedFragment);
        }
    }

    public String toString() {
        return "RekognizedFragmentsIndex(rekognizedOutputMap=" + this.rekognizedOutputMap + ", rekognizedOutputQueue=" + this.rekognizedOutputQueue + ")";
    }

    public static class RekognizedFragment {
        private final String fragmentNumber;
        private final Long producerTime;
        private final Long serverTime;
        private final List<RekognizedOutput> rekognizedOutputs = new ArrayList<RekognizedOutput>();

        public void addRekognizedOutput(RekognizedOutput rekognizedOutput) {
            this.rekognizedOutputs.add(rekognizedOutput);
        }

        public String getFragmentNumber() {
            return this.fragmentNumber;
        }

        public Long getProducerTime() {
            return this.producerTime;
        }

        public Long getServerTime() {
            return this.serverTime;
        }

        public List<RekognizedOutput> getRekognizedOutputs() {
            return this.rekognizedOutputs;
        }

        public String toString() {
            return "RekognizedFragmentsIndex.RekognizedFragment(fragmentNumber=" + this.getFragmentNumber() + ", producerTime=" + this.getProducerTime() + ", serverTime=" + this.getServerTime() + ", rekognizedOutputs=" + this.getRekognizedOutputs() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RekognizedFragment)) {
                return false;
            }
            RekognizedFragment other = (RekognizedFragment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$producerTime = this.getProducerTime();
            Long other$producerTime = other.getProducerTime();
            if (this$producerTime == null ? other$producerTime != null : !((Object)this$producerTime).equals(other$producerTime)) {
                return false;
            }
            Long this$serverTime = this.getServerTime();
            Long other$serverTime = other.getServerTime();
            if (this$serverTime == null ? other$serverTime != null : !((Object)this$serverTime).equals(other$serverTime)) {
                return false;
            }
            String this$fragmentNumber = this.getFragmentNumber();
            String other$fragmentNumber = other.getFragmentNumber();
            if (this$fragmentNumber == null ? other$fragmentNumber != null : !this$fragmentNumber.equals(other$fragmentNumber)) {
                return false;
            }
            List<RekognizedOutput> this$rekognizedOutputs = this.getRekognizedOutputs();
            List<RekognizedOutput> other$rekognizedOutputs = other.getRekognizedOutputs();
            return !(this$rekognizedOutputs == null ? other$rekognizedOutputs != null : !((Object)this$rekognizedOutputs).equals(other$rekognizedOutputs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RekognizedFragment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $producerTime = this.getProducerTime();
            result = result * 59 + ($producerTime == null ? 43 : ((Object)$producerTime).hashCode());
            Long $serverTime = this.getServerTime();
            result = result * 59 + ($serverTime == null ? 43 : ((Object)$serverTime).hashCode());
            String $fragmentNumber = this.getFragmentNumber();
            result = result * 59 + ($fragmentNumber == null ? 43 : $fragmentNumber.hashCode());
            List<RekognizedOutput> $rekognizedOutputs = this.getRekognizedOutputs();
            result = result * 59 + ($rekognizedOutputs == null ? 43 : ((Object)$rekognizedOutputs).hashCode());
            return result;
        }

        public RekognizedFragment(String fragmentNumber, Long producerTime, Long serverTime) {
            this.fragmentNumber = fragmentNumber;
            this.producerTime = producerTime;
            this.serverTime = serverTime;
        }
    }
}

