/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.rekognition.processor;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.kinesisvideo.parser.rekognition.pojo.RekognitionInput;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.rekognition.AmazonRekognition;
import com.amazonaws.services.rekognition.AmazonRekognitionClientBuilder;
import com.amazonaws.services.rekognition.model.CreateStreamProcessorRequest;
import com.amazonaws.services.rekognition.model.CreateStreamProcessorResult;
import com.amazonaws.services.rekognition.model.DeleteStreamProcessorRequest;
import com.amazonaws.services.rekognition.model.DeleteStreamProcessorResult;
import com.amazonaws.services.rekognition.model.DescribeStreamProcessorRequest;
import com.amazonaws.services.rekognition.model.DescribeStreamProcessorResult;
import com.amazonaws.services.rekognition.model.FaceSearchSettings;
import com.amazonaws.services.rekognition.model.KinesisDataStream;
import com.amazonaws.services.rekognition.model.KinesisVideoStream;
import com.amazonaws.services.rekognition.model.ListStreamProcessorsRequest;
import com.amazonaws.services.rekognition.model.ListStreamProcessorsResult;
import com.amazonaws.services.rekognition.model.ResourceNotFoundException;
import com.amazonaws.services.rekognition.model.StartStreamProcessorRequest;
import com.amazonaws.services.rekognition.model.StartStreamProcessorResult;
import com.amazonaws.services.rekognition.model.StopStreamProcessorRequest;
import com.amazonaws.services.rekognition.model.StopStreamProcessorResult;
import com.amazonaws.services.rekognition.model.StreamProcessor;
import com.amazonaws.services.rekognition.model.StreamProcessorInput;
import com.amazonaws.services.rekognition.model.StreamProcessorOutput;
import com.amazonaws.services.rekognition.model.StreamProcessorSettings;
import com.amazonaws.services.rekognition.model.StreamProcessorStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RekognitionStreamProcessor {
    private static final Logger log = LoggerFactory.getLogger(RekognitionStreamProcessor.class);
    private String streamProcessorName;
    private String kinesisVideoStreamArn;
    private String kinesisDataStreamArn;
    private String roleArn;
    private String collectionId;
    private float matchThreshold;
    private String region;
    private AmazonRekognition rekognitionClient;

    private RekognitionStreamProcessor(Regions regions, AWSCredentialsProvider provider, RekognitionInput rekognitionInput) {
        this.streamProcessorName = rekognitionInput.getStreamingProcessorName();
        this.kinesisVideoStreamArn = rekognitionInput.getKinesisVideoStreamArn();
        this.kinesisDataStreamArn = rekognitionInput.getKinesisDataStreamArn();
        this.roleArn = rekognitionInput.getIamRoleArn();
        this.collectionId = rekognitionInput.getFaceCollectionId();
        this.matchThreshold = rekognitionInput.getMatchThreshold().floatValue();
        this.rekognitionClient = (AmazonRekognition)((AmazonRekognitionClientBuilder)((AmazonRekognitionClientBuilder)AmazonRekognitionClientBuilder.standard().withRegion(regions)).withCredentials(provider)).build();
    }

    public static RekognitionStreamProcessor create(Regions regions, AWSCredentialsProvider provider, RekognitionInput rekognitionInput) {
        return new RekognitionStreamProcessor(regions, provider, rekognitionInput);
    }

    public void process() {
        try {
            DescribeStreamProcessorResult result = this.describeStreamProcessor();
            if (!result.getStatus().equals(StreamProcessorStatus.RUNNING.toString())) {
                this.startStreamProcessor();
            }
        }
        catch (ResourceNotFoundException e) {
            log.info("StreamProcessor with name : {} doesnt exist. Creating...", (Object)this.streamProcessorName);
            this.createStreamProcessor();
            this.startStreamProcessor();
        }
        this.describeStreamProcessor();
    }

    public CreateStreamProcessorResult createStreamProcessor() {
        KinesisVideoStream kinesisVideoStream = new KinesisVideoStream().withArn(this.kinesisVideoStreamArn);
        StreamProcessorInput streamProcessorInput = new StreamProcessorInput().withKinesisVideoStream(kinesisVideoStream);
        KinesisDataStream kinesisDataStream = new KinesisDataStream().withArn(this.kinesisDataStreamArn);
        StreamProcessorOutput streamProcessorOutput = new StreamProcessorOutput().withKinesisDataStream(kinesisDataStream);
        FaceSearchSettings faceSearchSettings = new FaceSearchSettings().withCollectionId(this.collectionId).withFaceMatchThreshold(Float.valueOf(this.matchThreshold));
        StreamProcessorSettings streamProcessorSettings = new StreamProcessorSettings().withFaceSearch(faceSearchSettings);
        CreateStreamProcessorResult createStreamProcessorResult = this.rekognitionClient.createStreamProcessor(new CreateStreamProcessorRequest().withInput(streamProcessorInput).withOutput(streamProcessorOutput).withSettings(streamProcessorSettings).withRoleArn(this.roleArn).withName(this.streamProcessorName));
        log.info("StreamProcessorArn : {} ", (Object)createStreamProcessorResult.getStreamProcessorArn());
        return createStreamProcessorResult;
    }

    public StartStreamProcessorResult startStreamProcessor() {
        StartStreamProcessorResult startStreamProcessorResult = this.rekognitionClient.startStreamProcessor(new StartStreamProcessorRequest().withName(this.streamProcessorName));
        log.info("SdkResponseMetadata : {} ", (Object)startStreamProcessorResult.getSdkResponseMetadata());
        return startStreamProcessorResult;
    }

    public StopStreamProcessorResult stopStreamProcessor() {
        StopStreamProcessorResult stopStreamProcessorResult = this.rekognitionClient.stopStreamProcessor(new StopStreamProcessorRequest().withName(this.streamProcessorName));
        log.info("SdkResponseMetadata : {} ", (Object)stopStreamProcessorResult.getSdkResponseMetadata());
        return stopStreamProcessorResult;
    }

    public DeleteStreamProcessorResult deleteStreamProcessor() {
        DeleteStreamProcessorResult deleteStreamProcessorResult = this.rekognitionClient.deleteStreamProcessor(new DeleteStreamProcessorRequest().withName(this.streamProcessorName));
        log.info("SdkResponseMetadata : {} ", (Object)deleteStreamProcessorResult.getSdkResponseMetadata());
        return deleteStreamProcessorResult;
    }

    public DescribeStreamProcessorResult describeStreamProcessor() {
        DescribeStreamProcessorResult describeStreamProcessorResult = this.rekognitionClient.describeStreamProcessor(new DescribeStreamProcessorRequest().withName(this.streamProcessorName));
        log.info("Arn : {}", (Object)describeStreamProcessorResult.getStreamProcessorArn());
        log.info("Input kinesisVideo stream : {} ", (Object)describeStreamProcessorResult.getInput().getKinesisVideoStream().getArn());
        log.info("Output kinesisData stream {} ", (Object)describeStreamProcessorResult.getOutput().getKinesisDataStream().getArn());
        log.info("RoleArn {} ", (Object)describeStreamProcessorResult.getRoleArn());
        log.info("CollectionId {} ", (Object)describeStreamProcessorResult.getSettings().getFaceSearch().getCollectionId());
        log.info("Status {} ", (Object)describeStreamProcessorResult.getStatus());
        log.info("Status message {} ", (Object)describeStreamProcessorResult.getStatusMessage());
        log.info("Creation timestamp {} ", (Object)describeStreamProcessorResult.getCreationTimestamp());
        log.info("Last update timestamp {} ", (Object)describeStreamProcessorResult.getLastUpdateTimestamp());
        return describeStreamProcessorResult;
    }

    public ListStreamProcessorsResult listStreamProcessor() {
        ListStreamProcessorsResult listStreamProcessorsResult = this.rekognitionClient.listStreamProcessors(new ListStreamProcessorsRequest().withMaxResults(Integer.valueOf(100)));
        for (StreamProcessor streamProcessor : listStreamProcessorsResult.getStreamProcessors()) {
            log.info("StreamProcessor name {} ", (Object)streamProcessor.getName());
            log.info("Status {} ", (Object)streamProcessor.getStatus());
        }
        return listStreamProcessorsResult;
    }
}

