/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.model.AmazonDynamoDBException;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBHelper {
    private static final Logger log = LoggerFactory.getLogger(DynamoDBHelper.class);
    private static final String TABLE_NAME = "FragmentCheckpoint";
    private static final String KVS_STREAM_NAME = "KVSStreamName";
    private static final String FRAGMENT_NUMBER = "FragmentNumber";
    private static final String SERVER_TIME = "ServerTime";
    private static final String PRODUCER_TIME = "ProducerTime";
    private static final String UPDATED_TIME = "UpdatedTime";
    private final AmazonDynamoDB ddbClient;

    public DynamoDBHelper(Regions region, AWSCredentialsProvider credentialsProvider) {
        ClientConfiguration clientConfiguration = new ClientConfiguration().withConnectionTimeout(10000).withRetryPolicy(ClientConfiguration.DEFAULT_RETRY_POLICY).withRequestTimeout(0).withSocketTimeout(50000);
        this.ddbClient = (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClient.builder().withClientConfiguration(clientConfiguration)).withCredentials(credentialsProvider)).withRegion(region)).build();
    }

    public void createTableIfDoesntExist() {
        if (!this.checkIfTableExists()) {
            log.info("Creating table : {}", (Object)TABLE_NAME);
            CreateTableRequest request = new CreateTableRequest(){
                {
                    this.setAttributeDefinitions(Collections.singletonList(new AttributeDefinition(DynamoDBHelper.KVS_STREAM_NAME, ScalarAttributeType.S)));
                    this.setKeySchema(Collections.singletonList(new KeySchemaElement(DynamoDBHelper.KVS_STREAM_NAME, KeyType.HASH)));
                    this.setProvisionedThroughput(new ProvisionedThroughput(Long.valueOf(1000L), Long.valueOf(1000L)));
                    this.setTableName(DynamoDBHelper.TABLE_NAME);
                }
            };
            try {
                CreateTableResult result = this.ddbClient.createTable(request);
                log.info("Table created : {}", (Object)result.getTableDescription());
            }
            catch (AmazonDynamoDBException e) {
                log.error("Error creating DDB table {}...", (Object)TABLE_NAME, (Object)e);
                throw e;
            }
        }
    }

    private boolean checkIfTableExists() {
        try {
            DescribeTableRequest request = new DescribeTableRequest(){
                {
                    this.setTableName(DynamoDBHelper.TABLE_NAME);
                }
            };
            TableDescription table_info = this.ddbClient.describeTable(request).getTable();
            log.info("Table exists : {}", (Object)table_info.getTableName());
            return true;
        }
        catch (ResourceNotFoundException e) {
            log.warn("{} table doesn't exist !", (Object)TABLE_NAME);
        }
        catch (AmazonDynamoDBException e) {
            log.warn("Error while describing table!", (Throwable)e);
        }
        return false;
    }

    public Map<String, AttributeValue> getItem(String streamName) {
        try {
            final HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put(KVS_STREAM_NAME, new AttributeValue().withS(streamName));
            GetItemRequest getItemRequest = new GetItemRequest(){
                {
                    this.setTableName(DynamoDBHelper.TABLE_NAME);
                    this.setKey(key);
                }
            };
            return this.ddbClient.getItem(getItemRequest).getItem();
        }
        catch (AmazonDynamoDBException e) {
            log.warn("Error while getting item from table!", (Throwable)e);
            return null;
        }
    }

    public void putItem(String streamName, String fragmentNumber, Long producerTime, Long serverTime, Long updatedTime) {
        try {
            final HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
            item.put(KVS_STREAM_NAME, new AttributeValue().withS(streamName));
            item.put(FRAGMENT_NUMBER, new AttributeValue().withS(fragmentNumber));
            item.put(UPDATED_TIME, new AttributeValue().withN(updatedTime.toString()));
            item.put(PRODUCER_TIME, new AttributeValue().withN(producerTime.toString()));
            item.put(SERVER_TIME, new AttributeValue().withN(serverTime.toString()));
            PutItemRequest putItemRequest = new PutItemRequest(){
                {
                    this.setTableName(DynamoDBHelper.TABLE_NAME);
                    this.setItem(item);
                }
            };
            PutItemResult result = this.ddbClient.putItem(putItemRequest);
            log.info("Item saved : ", (Object)result.getAttributes());
        }
        catch (Exception e) {
            log.warn("Error while putting item into the table!", (Throwable)e);
        }
    }

    public void updateItem(String streamName, String fragmentNumber, Long producerTime, Long serverTime, Long updatedTime) {
        try {
            final HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put(KVS_STREAM_NAME, new AttributeValue().withS(streamName));
            final HashMap<String, AttributeValueUpdate> updates = new HashMap<String, AttributeValueUpdate>();
            updates.put(FRAGMENT_NUMBER, new AttributeValueUpdate().withValue(new AttributeValue().withS(fragmentNumber)));
            updates.put(UPDATED_TIME, new AttributeValueUpdate().withValue(new AttributeValue().withN(updatedTime.toString())));
            updates.put(PRODUCER_TIME, new AttributeValueUpdate().withValue(new AttributeValue().withN(producerTime.toString())));
            updates.put(SERVER_TIME, new AttributeValueUpdate().withValue(new AttributeValue().withN(serverTime.toString())));
            UpdateItemRequest updateItemRequest = new UpdateItemRequest(){
                {
                    this.setTableName(DynamoDBHelper.TABLE_NAME);
                    this.setKey(key);
                    this.setAttributeUpdates(updates);
                }
            };
            UpdateItemResult result = this.ddbClient.updateItem(updateItemRequest);
            log.info("Item updated : {}", (Object)result.getAttributes());
        }
        catch (Exception e) {
            log.warn("Error while updating item in the table!", (Throwable)e);
        }
    }
}

