/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities;

import com.amazonaws.kinesisvideo.parser.ebml.MkvTypeInfos;
import com.amazonaws.kinesisvideo.parser.mkv.Frame;
import com.amazonaws.kinesisvideo.parser.mkv.FrameProcessException;
import com.amazonaws.kinesisvideo.parser.mkv.MkvDataElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitException;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.MkvEndMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvStartMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvValue;
import com.amazonaws.kinesisvideo.parser.mkv.visitors.CompositeMkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.FragmentMetadata;
import com.amazonaws.kinesisvideo.parser.utilities.FragmentMetadataVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.MkvTrackMetadata;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameVisitor
extends CompositeMkvElementVisitor {
    private static final Logger log = LoggerFactory.getLogger(FrameVisitor.class);
    private final FragmentMetadataVisitor fragmentMetadataVisitor;
    private final FrameVisitorInternal frameVisitorInternal;
    private final FrameProcessor frameProcessor;
    private final Optional<Long> trackNumber;
    private final Optional<FragmentMetadataVisitor.MkvTagProcessor> tagProcessor;
    private Optional<BigInteger> timescale;
    private Optional<BigInteger> fragmentTimecode;

    private FrameVisitor(FragmentMetadataVisitor fragmentMetadataVisitor, Optional<FragmentMetadataVisitor.MkvTagProcessor> tagProcessor, FrameProcessor frameProcessor, Optional<Long> trackNumber) {
        super(fragmentMetadataVisitor);
        this.fragmentMetadataVisitor = fragmentMetadataVisitor;
        this.frameVisitorInternal = new FrameVisitorInternal();
        this.childVisitors.add(this.frameVisitorInternal);
        this.frameProcessor = frameProcessor;
        this.tagProcessor = tagProcessor;
        this.trackNumber = trackNumber;
        this.timescale = Optional.empty();
        this.fragmentTimecode = Optional.empty();
    }

    public static FrameVisitor create(FrameProcessor frameProcessor) {
        return new FrameVisitor(FragmentMetadataVisitor.create(), Optional.empty(), frameProcessor, Optional.empty());
    }

    public static FrameVisitor create(FrameProcessor frameProcessor, Optional<FragmentMetadataVisitor.MkvTagProcessor> tagProcessor) {
        return new FrameVisitor(FragmentMetadataVisitor.create(tagProcessor), tagProcessor, frameProcessor, Optional.empty());
    }

    public static FrameVisitor create(FrameProcessor frameProcessor, Optional<FragmentMetadataVisitor.MkvTagProcessor> tagProcessor, Optional<Long> trackNumber) {
        return new FrameVisitor(FragmentMetadataVisitor.create(tagProcessor), tagProcessor, frameProcessor, trackNumber);
    }

    public void close() {
        this.frameProcessor.close();
    }

    private class FrameVisitorInternal
    extends MkvElementVisitor {
        private FrameVisitorInternal() {
        }

        @Override
        public void visit(MkvStartMasterElement startMasterElement) throws MkvElementVisitException {
        }

        @Override
        public void visit(MkvEndMasterElement endMasterElement) throws MkvElementVisitException {
            if (FrameVisitor.this.tagProcessor.isPresent() && MkvTypeInfos.CLUSTER.equals(endMasterElement.getElementMetaData().getTypeInfo())) {
                ((FragmentMetadataVisitor.MkvTagProcessor)FrameVisitor.this.tagProcessor.get()).clear();
            }
        }

        @Override
        public void visit(MkvDataElement dataElement) throws MkvElementVisitException {
            if (MkvTypeInfos.TIMECODESCALE.equals(dataElement.getElementMetaData().getTypeInfo())) {
                FrameVisitor.this.timescale = Optional.of((BigInteger)dataElement.getValueCopy().getVal());
            }
            if (MkvTypeInfos.TIMECODE.equals(dataElement.getElementMetaData().getTypeInfo())) {
                FrameVisitor.this.fragmentTimecode = Optional.of((BigInteger)dataElement.getValueCopy().getVal());
            }
            if (MkvTypeInfos.SIMPLEBLOCK.equals(dataElement.getElementMetaData().getTypeInfo())) {
                MkvValue frame = dataElement.getValueCopy();
                Validate.notNull((Object)frame);
                long frameTrackNo = ((Frame)frame.getVal()).getTrackNumber();
                MkvTrackMetadata trackMetadata = FrameVisitor.this.fragmentMetadataVisitor.getMkvTrackMetadata(frameTrackNo);
                if (FrameVisitor.this.trackNumber.orElse(frameTrackNo) == frameTrackNo) {
                    FrameVisitor.this.frameProcessor.process((Frame)frame.getVal(), trackMetadata, FrameVisitor.this.fragmentMetadataVisitor.getCurrentFragmentMetadata(), FrameVisitor.this.tagProcessor, FrameVisitor.this.timescale, FrameVisitor.this.fragmentTimecode);
                }
            }
        }
    }

    public static interface FrameProcessor
    extends AutoCloseable {
        default public void process(Frame frame, MkvTrackMetadata trackMetadata, Optional<FragmentMetadata> fragmentMetadata) throws FrameProcessException {
            throw new NotImplementedException("Default FrameVisitor.FrameProcessor");
        }

        default public void process(Frame frame, MkvTrackMetadata trackMetadata, Optional<FragmentMetadata> fragmentMetadata, Optional<FragmentMetadataVisitor.MkvTagProcessor> tagProcessor) throws FrameProcessException {
            if (tagProcessor.isPresent()) {
                throw new NotImplementedException("Default FrameVisitor.FrameProcessor");
            }
            this.process(frame, trackMetadata, fragmentMetadata);
        }

        default public void process(Frame frame, MkvTrackMetadata trackMetadata, Optional<FragmentMetadata> fragmentMetadata, Optional<FragmentMetadataVisitor.MkvTagProcessor> tagProcessor, Optional<BigInteger> timescale, Optional<BigInteger> fragmentTimecode) throws FrameProcessException {
            this.process(frame, trackMetadata, fragmentMetadata, tagProcessor);
        }

        @Override
        default public void close() {
        }
    }
}

