/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities;

import com.amazonaws.kinesisvideo.parser.examples.KinesisVideoBoundingBoxFrameViewer;
import com.amazonaws.kinesisvideo.parser.mkv.Frame;
import com.amazonaws.kinesisvideo.parser.mkv.FrameProcessException;
import com.amazonaws.kinesisvideo.parser.rekognition.pojo.RekognizedFragmentsIndex;
import com.amazonaws.kinesisvideo.parser.rekognition.pojo.RekognizedOutput;
import com.amazonaws.kinesisvideo.parser.utilities.FragmentMetadata;
import com.amazonaws.kinesisvideo.parser.utilities.FragmentMetadataVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.H264FrameRenderer;
import com.amazonaws.kinesisvideo.parser.utilities.MkvTrackMetadata;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H264BoundingBoxFrameRenderer
extends H264FrameRenderer {
    private static final Logger log = LoggerFactory.getLogger(H264BoundingBoxFrameRenderer.class);
    private static final int DEFAULT_MAX_TIMEOUT = 100;
    private static final int WAIT_TIMEOUT = 3;
    private static final int MILLIS_IN_SEC = 1000;
    private static final int OFFSET_DELTA_THRESHOLD = 10;
    private final KinesisVideoBoundingBoxFrameViewer kinesisVideoBoundingBoxFrameViewer;
    private final RekognizedFragmentsIndex rekognizedFragmentsIndex;
    private RekognizedOutput currentRekognizedOutput = null;
    private int maxTimeout = 100;
    private long keyFrameTimecode;

    private H264BoundingBoxFrameRenderer(KinesisVideoBoundingBoxFrameViewer kinesisVideoBoundingBoxFrameViewer, RekognizedFragmentsIndex rekognizedFragmentsIndex) {
        super(kinesisVideoBoundingBoxFrameViewer);
        this.kinesisVideoBoundingBoxFrameViewer = kinesisVideoBoundingBoxFrameViewer;
        this.rekognizedFragmentsIndex = rekognizedFragmentsIndex;
    }

    public static H264BoundingBoxFrameRenderer create(KinesisVideoBoundingBoxFrameViewer kinesisVideoBoundingBoxFrameViewer, RekognizedFragmentsIndex rekognizedFragmentsIndex) {
        return new H264BoundingBoxFrameRenderer(kinesisVideoBoundingBoxFrameViewer, rekognizedFragmentsIndex);
    }

    @Override
    public void process(Frame frame, MkvTrackMetadata trackMetadata, Optional<FragmentMetadata> fragmentMetadata, Optional<FragmentMetadataVisitor.MkvTagProcessor> tagProcessor) throws FrameProcessException {
        BufferedImage bufferedImage = this.decodeH264Frame(frame, trackMetadata);
        Optional<RekognizedOutput> rekognizedOutput = this.getRekognizedOutput(frame, fragmentMetadata);
        this.renderFrame(bufferedImage, rekognizedOutput);
    }

    private Optional<RekognizedOutput> getRekognizedOutput(Frame frame, Optional<FragmentMetadata> fragmentMetadata) {
        Optional<RekognizedOutput> rekognizedOutput = Optional.empty();
        if (this.rekognizedFragmentsIndex != null && fragmentMetadata.isPresent()) {
            String fragmentNumber = fragmentMetadata.get().getFragmentNumberString();
            int timeout = 0;
            List<RekognizedOutput> rekognizedOutputs = null;
            while ((rekognizedOutputs = this.rekognizedFragmentsIndex.getRekognizedOutputList(fragmentNumber)) == null) {
                if ((timeout = (int)((long)timeout + this.waitForResults(3L))) < this.maxTimeout) continue;
                log.warn("No rekognized result after waiting for {} ms ", (Object)timeout);
                break;
            }
            if (rekognizedOutputs != null) {
                if (frame.isKeyFrame()) {
                    this.keyFrameTimecode = frame.getTimeCode();
                    log.debug("Key frame timecode : {}", (Object)this.keyFrameTimecode);
                }
                long frameOffset = (long)frame.getTimeCode() > this.keyFrameTimecode ? (long)frame.getTimeCode() - this.keyFrameTimecode : 0L;
                log.debug("Current Fragment Number : {} Computed Frame offset : {}", (Object)fragmentNumber, (Object)frameOffset);
                if (log.isDebugEnabled()) {
                    rekognizedOutputs.forEach(p -> log.debug("frameOffsetInSeconds from Rekognition : {}", (Object)p.getFrameOffsetInSeconds()));
                }
                if ((rekognizedOutput = rekognizedOutputs.stream().filter(p -> this.isOffsetDeltaWithinThreshold(frameOffset, (RekognizedOutput)p)).findFirst()).isPresent()) {
                    log.debug("Computed offset matched with retrieved offset. Delta : {}", (Object)Math.abs((double)frameOffset - rekognizedOutput.get().getFrameOffsetInSeconds() * 1000.0));
                    rekognizedOutputs.remove(rekognizedOutput.get());
                    if (rekognizedOutputs.isEmpty()) {
                        log.debug("All frames processed for this fragment number : {}", (Object)fragmentNumber);
                        this.rekognizedFragmentsIndex.remove(fragmentNumber);
                    }
                }
            }
        }
        return rekognizedOutput;
    }

    private boolean isOffsetDeltaWithinThreshold(long frameOffset, RekognizedOutput output) {
        return Math.abs((double)frameOffset - output.getFrameOffsetInSeconds() * 1000.0) <= 10.0;
    }

    void renderFrame(BufferedImage bufferedImage, Optional<RekognizedOutput> rekognizedOutput) {
        if (rekognizedOutput.isPresent()) {
            System.out.println("Rendering Rekognized sampled frame...");
            this.kinesisVideoBoundingBoxFrameViewer.update(bufferedImage, rekognizedOutput.get());
            this.currentRekognizedOutput = rekognizedOutput.get();
        } else if (this.currentRekognizedOutput != null) {
            System.out.println("Rendering non-sampled frame with previous rekognized results...");
            this.kinesisVideoBoundingBoxFrameViewer.update(bufferedImage, this.currentRekognizedOutput);
        } else {
            System.out.println("Rendering frame without any rekognized results...");
            this.kinesisVideoBoundingBoxFrameViewer.update(bufferedImage);
        }
    }

    private long waitForResults(long timeout) {
        long startTime = System.currentTimeMillis();
        try {
            log.info("No rekognized results for this fragment number. Waiting ....");
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            log.warn("Error while waiting for rekognized output !", (Throwable)e);
        }
        return System.currentTimeMillis() - startTime;
    }

    public void setMaxTimeout(int maxTimeout) {
        this.maxTimeout = maxTimeout;
    }
}

