/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities;

import com.amazonaws.kinesisvideo.parser.mkv.Frame;
import com.amazonaws.kinesisvideo.parser.mkv.FrameProcessException;
import com.amazonaws.kinesisvideo.parser.utilities.FragmentMetadata;
import com.amazonaws.kinesisvideo.parser.utilities.FrameVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.MkvTrackMetadata;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import org.jcodec.codecs.h264.H264Decoder;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.mp4.AvcCBox;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.scale.AWTUtil;
import org.jcodec.scale.Transform;
import org.jcodec.scale.Yuv420jToRgb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H264FrameDecoder
implements FrameVisitor.FrameProcessor {
    private static final Logger log = LoggerFactory.getLogger(H264FrameDecoder.class);
    private final H264Decoder decoder = new H264Decoder();
    private final Transform transform = new Yuv420jToRgb();
    private int frameCount;
    private byte[] codecPrivateData;

    @Override
    public void process(Frame frame, MkvTrackMetadata trackMetadata, Optional<FragmentMetadata> fragmentMetadata) throws FrameProcessException {
        this.decodeH264Frame(frame, trackMetadata);
    }

    public BufferedImage decodeH264Frame(Frame frame, MkvTrackMetadata trackMetadata) {
        ByteBuffer frameBuffer = frame.getFrameData();
        int pixelWidth = trackMetadata.getPixelWidth().get().intValue();
        int pixelHeight = trackMetadata.getPixelHeight().get().intValue();
        this.codecPrivateData = trackMetadata.getCodecPrivateData().array();
        log.debug("Decoding frames ... ");
        Picture rgb = Picture.create((int)pixelWidth, (int)pixelHeight, (ColorSpace)ColorSpace.RGB);
        BufferedImage bufferedImage = new BufferedImage(pixelWidth, pixelHeight, 5);
        AvcCBox avcC = AvcCBox.parseAvcCBox((ByteBuffer)ByteBuffer.wrap(this.codecPrivateData));
        this.decoder.addSps(avcC.getSpsList());
        this.decoder.addPps(avcC.getPpsList());
        Picture buf = Picture.create((int)(pixelWidth + (16 - pixelWidth % 16) % 16), (int)(pixelHeight + (16 - pixelHeight % 16) % 16), (ColorSpace)ColorSpace.YUV420J);
        List byteBuffers = H264Utils.splitMOVPacket((ByteBuffer)frameBuffer, (AvcCBox)avcC);
        org.jcodec.codecs.h264.io.model.Frame pic = this.decoder.decodeFrameFromNals(byteBuffers, buf.getData());
        if (pic != null) {
            byte[][] dataTemp = new byte[3][pic.getData().length];
            dataTemp[0] = pic.getPlaneData(0);
            dataTemp[1] = pic.getPlaneData(2);
            dataTemp[2] = pic.getPlaneData(1);
            Picture tmpBuf = Picture.createPicture((int)pixelWidth, (int)pixelHeight, (byte[][])dataTemp, (ColorSpace)ColorSpace.YUV420J);
            this.transform.transform(tmpBuf, rgb);
            AWTUtil.toBufferedImage((Picture)rgb, (BufferedImage)bufferedImage);
            ++this.frameCount;
        }
        return bufferedImage;
    }

    public ByteBuffer getCodecPrivateData() {
        return ByteBuffer.wrap(this.codecPrivateData);
    }

    public int getFrameCount() {
        return this.frameCount;
    }
}

