/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities;

import com.amazonaws.kinesisvideo.parser.examples.lambda.EncodedFrame;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jcodec.codecs.h264.H264Encoder;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.encode.H264FixedRateControl;
import org.jcodec.codecs.h264.encode.RateControl;
import org.jcodec.codecs.h264.io.model.PictureParameterSet;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.io.model.SliceType;
import org.jcodec.codecs.h264.mp4.AvcCBox;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.common.model.Size;
import org.jcodec.scale.AWTUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H264FrameEncoder {
    private static final Logger log = LoggerFactory.getLogger(H264FrameEncoder.class);
    private Picture toEncode;
    private H264Encoder encoder;
    private SeqParameterSet sps;
    private PictureParameterSet pps;
    private ByteBuffer out;
    private byte[] cpd;
    private int frameNumber;

    public H264FrameEncoder(int width, int height, int bitRate) {
        this.encoder = new H264Encoder((RateControl)new H264FixedRateControl(bitRate));
        this.out = ByteBuffer.allocate(width * height * 6);
        this.frameNumber = 0;
        Size size = new Size(width, height);
        this.sps = this.encoder.initSPS(size);
        this.pps = this.encoder.initPPS();
        ByteBuffer spsBuffer = ByteBuffer.allocate(512);
        this.sps.write(spsBuffer);
        spsBuffer.flip();
        ByteBuffer serialSps = ByteBuffer.allocate(512);
        this.sps.write(serialSps);
        serialSps.flip();
        H264Utils.escapeNALinplace((ByteBuffer)serialSps);
        ByteBuffer serialPps = ByteBuffer.allocate(512);
        this.pps.write(serialPps);
        serialPps.flip();
        H264Utils.escapeNALinplace((ByteBuffer)serialPps);
        ByteBuffer serialAvcc = ByteBuffer.allocate(512);
        AvcCBox avcC = AvcCBox.createAvcCBox((int)this.sps.profileIdc, (int)0, (int)this.sps.levelIdc, (int)4, Arrays.asList(serialSps), Arrays.asList(serialPps));
        avcC.doWrite(serialAvcc);
        serialAvcc.flip();
        this.cpd = new byte[serialAvcc.remaining()];
        serialAvcc.get(this.cpd);
    }

    public EncodedFrame encodeFrame(BufferedImage bi) {
        this.out.clear();
        this.toEncode = AWTUtil.fromBufferedImage((BufferedImage)bi, (ColorSpace)ColorSpace.YUV420J);
        SliceType sliceType = this.frameNumber == 0 ? SliceType.I : SliceType.P;
        log.debug("Encoding frame no: {}, frame type : {}", (Object)this.frameNumber, (Object)sliceType);
        boolean idr = this.frameNumber == 0;
        ByteBuffer data = this.encoder.doEncodeFrame(this.toEncode, this.out, idr, this.frameNumber++, sliceType);
        return EncodedFrame.builder().byteBuffer(data).isKeyFrame(idr).cpd(ByteBuffer.wrap(this.cpd)).build();
    }

    public void setFrameNumber(int frameNumber) {
        this.frameNumber = frameNumber;
    }

    public SeqParameterSet getSps() {
        return this.sps;
    }

    public PictureParameterSet getPps() {
        return this.pps;
    }

    public byte[] getCodecPrivateData() {
        return (byte[])this.cpd.clone();
    }

    public int getKeyInterval() {
        return this.encoder.getKeyInterval();
    }
}

