/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities;

import com.amazonaws.kinesisvideo.parser.examples.KinesisVideoFrameViewer;
import com.amazonaws.kinesisvideo.parser.mkv.Frame;
import com.amazonaws.kinesisvideo.parser.mkv.FrameProcessException;
import com.amazonaws.kinesisvideo.parser.utilities.BufferedImageUtil;
import com.amazonaws.kinesisvideo.parser.utilities.FragmentMetadata;
import com.amazonaws.kinesisvideo.parser.utilities.FragmentMetadataVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.H264FrameDecoder;
import com.amazonaws.kinesisvideo.parser.utilities.MkvTrackMetadata;
import java.awt.image.BufferedImage;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H264FrameRenderer
extends H264FrameDecoder {
    private static final Logger log = LoggerFactory.getLogger(H264FrameRenderer.class);
    private static final int PIXEL_TO_LEFT = 10;
    private static final int PIXEL_TO_TOP_LINE_1 = 20;
    private static final int PIXEL_TO_TOP_LINE_2 = 40;
    private final KinesisVideoFrameViewer kinesisVideoFrameViewer;

    protected H264FrameRenderer(KinesisVideoFrameViewer kinesisVideoFrameViewer) {
        this.kinesisVideoFrameViewer = kinesisVideoFrameViewer;
        this.kinesisVideoFrameViewer.setVisible(true);
    }

    public static H264FrameRenderer create(KinesisVideoFrameViewer kinesisVideoFrameViewer) {
        return new H264FrameRenderer(kinesisVideoFrameViewer);
    }

    @Override
    public void process(Frame frame, MkvTrackMetadata trackMetadata, Optional<FragmentMetadata> fragmentMetadata, Optional<FragmentMetadataVisitor.MkvTagProcessor> tagProcessor) throws FrameProcessException {
        BufferedImage bufferedImage = this.decodeH264Frame(frame, trackMetadata);
        if (tagProcessor.isPresent()) {
            FragmentMetadataVisitor.BasicMkvTagProcessor processor = (FragmentMetadataVisitor.BasicMkvTagProcessor)tagProcessor.get();
            if (fragmentMetadata.isPresent()) {
                BufferedImageUtil.addTextToImage(bufferedImage, String.format("Fragment Number: %s", fragmentMetadata.get().getFragmentNumberString()), 10, 20);
            }
            if (processor.getTags().size() > 0) {
                BufferedImageUtil.addTextToImage(bufferedImage, "Fragment Metadata: " + processor.getTags().toString(), 10, 40);
            } else {
                BufferedImageUtil.addTextToImage(bufferedImage, "Fragment Metadata: No Metadata Available", 10, 40);
            }
        }
        this.kinesisVideoFrameViewer.update(bufferedImage);
    }
}

