/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities;

import com.amazonaws.kinesisvideo.client.mediasource.CameraMediaSourceConfiguration;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSourceConfiguration;
import com.amazonaws.kinesisvideo.internal.mediasource.bytes.BytesMediaSourceConfiguration;
import com.amazonaws.kinesisvideo.producer.StreamInfo;
import com.amazonaws.kinesisvideo.producer.Tag;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public final class ProducerStreamUtil {
    private static final boolean NOT_ADAPTIVE = false;
    private static final boolean KEYFRAME_FRAGMENTATION = true;
    private static final boolean SDK_GENERATES_TIMECODES = false;
    private static final boolean RELATIVE_FRAGMENT_TIMECODES = false;
    private static final String NO_KMS_KEY_ID = null;
    private static final int VERSION_ZERO = 0;
    private static final long MAX_LATENCY_ZERO = 0L;
    private static final long NO_RETENTION = 0L;
    private static final boolean REQUEST_FRAGMENT_ACKS = true;
    private static final boolean RECOVER_ON_FAILURE = true;
    private static final long DEFAULT_GOP_DURATION = 20000000000L;
    private static final int DEFAULT_BITRATE = 2000000;
    private static final int DEFAULT_TIMESCALE = 10000;
    private static final int FRAMERATE_30 = 30;
    private static final int FRAME_RATE_25 = 25;
    private static final boolean USE_FRAME_TIMECODES = true;
    private static final boolean ABSOLUTE_TIMECODES = true;
    private static final boolean RELATIVE_TIMECODES = false;
    private static final boolean RECALCULATE_METRICS = true;
    public static final long DEFAULT_BUFFER_DURATION_IN_SECONDS = 40L;
    public static final long DEFAULT_REPLAY_DURATION_IN_SECONDS = 20L;
    public static final long DEFAULT_STALENESS_DURATION_IN_SECONDS = 20L;

    public static StreamInfo toStreamInfo(String streamName, MediaSourceConfiguration mediaSourceConfiguration) throws KinesisVideoException {
        if (ProducerStreamUtil.isCameraConfiguration(mediaSourceConfiguration)) {
            return ProducerStreamUtil.getCameraStreamInfo(streamName, mediaSourceConfiguration);
        }
        if (ProducerStreamUtil.isBytesConfiguration(mediaSourceConfiguration)) {
            return ProducerStreamUtil.getBytesStreamInfo(streamName, mediaSourceConfiguration);
        }
        if (ProducerStreamUtil.isImageFileConfiguration(mediaSourceConfiguration)) {
            return ProducerStreamUtil.getImageFileStreamInfo(mediaSourceConfiguration, streamName);
        }
        throw new KinesisVideoException("Unable to create StreamInfo from media source configuration");
    }

    private static boolean isCameraConfiguration(MediaSourceConfiguration mediaSourceConfiguration) {
        return CameraMediaSourceConfiguration.class.isAssignableFrom(mediaSourceConfiguration.getClass());
    }

    private static boolean isBytesConfiguration(MediaSourceConfiguration mediaSourceConfiguration) {
        return BytesMediaSourceConfiguration.class.isAssignableFrom(mediaSourceConfiguration.getClass());
    }

    private static boolean isImageFileConfiguration(MediaSourceConfiguration mediaSourceConfiguration) {
        return mediaSourceConfiguration.getClass().getSimpleName().equals("ImageFileMediaSourceConfiguration");
    }

    private static StreamInfo getCameraStreamInfo(String streamName, MediaSourceConfiguration mediaSourceConfiguration) throws KinesisVideoException {
        CameraMediaSourceConfiguration configuration = (CameraMediaSourceConfiguration)mediaSourceConfiguration;
        String contentType = configuration.getEncoderMimeType();
        if (contentType.equals("video/avc")) {
            contentType = "video/h264";
        }
        return new StreamInfo(0, streamName, StreamInfo.StreamingType.STREAMING_TYPE_REALTIME, contentType, NO_KMS_KEY_ID, (long)configuration.getRetentionPeriodInHours() * 36000000000L, false, 0L, 200000000000000L, true, true, configuration.getIsAbsoluteTimecode(), true, true, StreamInfo.codecIdFromContentType((String)configuration.getEncoderMimeType()), StreamInfo.createTrackName((String)configuration.getEncoderMimeType()), configuration.getBitRate(), configuration.getFrameRate(), 400000000L, 200000000L, 200000000L, configuration.getTimeScale() / 100L, true, configuration.getCodecPrivateData(), ProducerStreamUtil.getTags(), configuration.getNalAdaptationFlags());
    }

    private static StreamInfo getBytesStreamInfo(String streamName, MediaSourceConfiguration mediaSourceConfiguration) throws KinesisVideoException {
        BytesMediaSourceConfiguration configuration = (BytesMediaSourceConfiguration)mediaSourceConfiguration;
        return new StreamInfo(0, streamName, StreamInfo.StreamingType.STREAMING_TYPE_REALTIME, "application/octet-stream", NO_KMS_KEY_ID, configuration.getRetentionPeriodInHours() * 36000000000L, false, 0L, 200000000000000L, true, true, true, true, true, null, null, 2000000, 30, 400000000L, 200000000L, 200000000L, 10000L, true, null, ProducerStreamUtil.getTags(), StreamInfo.NalAdaptationFlags.NAL_ADAPTATION_FLAG_NONE);
    }

    private static StreamInfo getImageFileStreamInfo(MediaSourceConfiguration configuration, String streamName) throws KinesisVideoException {
        try {
            return (StreamInfo)configuration.getClass().getMethod("toStreamInfo", String.class).invoke((Object)configuration, streamName);
        }
        catch (IllegalAccessException e) {
            throw new KinesisVideoException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new KinesisVideoException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new KinesisVideoException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new KinesisVideoException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new KinesisVideoException((Throwable)e);
        }
    }

    private static Tag[] getTags() {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        tagList.add(new Tag("device", "Test Device"));
        tagList.add(new Tag("stream", "Test Stream"));
        return tagList.toArray(new Tag[0]);
    }

    private ProducerStreamUtil() {
    }
}

