/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities;

import com.amazonaws.kinesisvideo.parser.ebml.MkvTypeInfos;
import com.amazonaws.kinesisvideo.parser.mkv.Frame;
import com.amazonaws.kinesisvideo.parser.mkv.MkvDataElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitException;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.MkvEndMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvStartMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvValue;
import com.amazonaws.kinesisvideo.parser.mkv.visitors.CompositeMkvElementVisitor;
import java.math.BigInteger;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFrameVisitor
extends CompositeMkvElementVisitor {
    private static final Logger log = LoggerFactory.getLogger(SimpleFrameVisitor.class);
    private final FrameVisitorInternal frameVisitorInternal;
    private final FrameProcessor frameProcessor;

    private SimpleFrameVisitor(FrameProcessor frameProcessor) {
        super(new MkvElementVisitor[0]);
        this.frameProcessor = frameProcessor;
        this.frameVisitorInternal = new FrameVisitorInternal();
        this.childVisitors.add(this.frameVisitorInternal);
    }

    public static SimpleFrameVisitor create(FrameProcessor frameProcessor) {
        return new SimpleFrameVisitor(frameProcessor);
    }

    private class FrameVisitorInternal
    extends MkvElementVisitor {
        private long clusterTimeCode = -1L;
        private long timeCodeScale = -1L;

        private FrameVisitorInternal() {
        }

        @Override
        public void visit(MkvStartMasterElement startMasterElement) throws MkvElementVisitException {
        }

        @Override
        public void visit(MkvEndMasterElement endMasterElement) throws MkvElementVisitException {
        }

        @Override
        public void visit(MkvDataElement dataElement) throws MkvElementVisitException {
            if (MkvTypeInfos.TIMECODE.equals(dataElement.getElementMetaData().getTypeInfo())) {
                this.clusterTimeCode = ((BigInteger)dataElement.getValueCopy().getVal()).longValue();
            }
            if (MkvTypeInfos.TIMECODESCALE.equals(dataElement.getElementMetaData().getTypeInfo())) {
                this.timeCodeScale = ((BigInteger)dataElement.getValueCopy().getVal()).longValue();
            }
            if (MkvTypeInfos.SIMPLEBLOCK.equals(dataElement.getElementMetaData().getTypeInfo())) {
                if (this.clusterTimeCode == -1L || this.timeCodeScale == -1L) {
                    throw new MkvElementVisitException("No timeCodeScale or timeCode found", new RuntimeException());
                }
                MkvValue frame = dataElement.getValueCopy();
                Validate.notNull((Object)frame);
                SimpleFrameVisitor.this.frameProcessor.process((Frame)frame.getVal(), this.clusterTimeCode, this.timeCodeScale);
            }
        }
    }

    public static interface FrameProcessor {
        default public void process(Frame frame, long clusterTimeCode, long timeCodeScale) {
            throw new NotImplementedException("Default FrameVisitor with No Fragement MetaData");
        }
    }
}

