/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities.consumer;

import com.amazonaws.kinesisvideo.parser.ebml.MkvTypeInfos;
import com.amazonaws.kinesisvideo.parser.mkv.MkvDataElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitException;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.MkvEndMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvStartMasterElement;
import com.amazonaws.kinesisvideo.parser.mkv.visitors.CompositeMkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.visitors.CountVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.FragmentMetadataVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.consumer.FragmentMetadataCallback;

public class FragmentProgressTracker
extends CompositeMkvElementVisitor {
    private final CountVisitor countVisitor;

    private FragmentProgressTracker(MkvElementVisitor processingVisitor, FragmentMetadataVisitor metadataVisitor, CountVisitor countVisitor, EndOfSegmentVisitor endOfSegmentVisitor) {
        super(metadataVisitor, processingVisitor, countVisitor, endOfSegmentVisitor);
        this.countVisitor = countVisitor;
    }

    public static FragmentProgressTracker create(MkvElementVisitor processingVisitor, FragmentMetadataCallback callback) {
        FragmentMetadataVisitor metadataVisitor = FragmentMetadataVisitor.create();
        return new FragmentProgressTracker(processingVisitor, metadataVisitor, CountVisitor.create(MkvTypeInfos.CLUSTER, MkvTypeInfos.SEGMENT, MkvTypeInfos.SIMPLEBLOCK, MkvTypeInfos.TAG), new EndOfSegmentVisitor(metadataVisitor, callback));
    }

    public int getClustersCount() {
        return this.countVisitor.getCount(MkvTypeInfos.CLUSTER);
    }

    public int getSegmentsCount() {
        return this.countVisitor.getCount(MkvTypeInfos.SEGMENT);
    }

    public int getSimpleBlocksCount() {
        return this.countVisitor.getCount(MkvTypeInfos.SIMPLEBLOCK);
    }

    private static class EndOfSegmentVisitor
    extends MkvElementVisitor {
        private final FragmentMetadataVisitor metadataVisitor;
        private final FragmentMetadataCallback endOfFragmentCallback;

        @Override
        public void visit(MkvStartMasterElement startMasterElement) throws MkvElementVisitException {
        }

        @Override
        public void visit(MkvEndMasterElement endMasterElement) throws MkvElementVisitException {
            if (MkvTypeInfos.SEGMENT.equals(endMasterElement.getElementMetaData().getTypeInfo())) {
                this.metadataVisitor.getCurrentFragmentMetadata().ifPresent(this.endOfFragmentCallback::call);
            }
        }

        @Override
        public void visit(MkvDataElement dataElement) throws MkvElementVisitException {
        }

        public EndOfSegmentVisitor(FragmentMetadataVisitor metadataVisitor, FragmentMetadataCallback endOfFragmentCallback) {
            this.metadataVisitor = metadataVisitor;
            this.endOfFragmentCallback = endOfFragmentCallback;
        }
    }
}

