/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities.consumer;

import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitException;
import com.amazonaws.kinesisvideo.parser.utilities.OutputSegmentMerger;
import com.amazonaws.kinesisvideo.parser.utilities.consumer.FragmentMetadataCallback;
import com.amazonaws.kinesisvideo.parser.utilities.consumer.GetMediaResponseStreamConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MergedOutputPiper
extends GetMediaResponseStreamConsumer {
    private final ProcessBuilder childProcessBuilder;
    private OutputSegmentMerger merger;
    private Process targetProcess;

    @Override
    public void process(InputStream inputStream, FragmentMetadataCallback endOfFragmentCallback) throws MkvElementVisitException, IOException {
        this.targetProcess = this.childProcessBuilder.start();
        try (OutputStream os = this.targetProcess.getOutputStream();){
            this.merger = OutputSegmentMerger.createToStopAtFirstNonMatchingSegment(os);
            this.processWithFragmentEndCallbacks(inputStream, endOfFragmentCallback, this.merger);
        }
    }

    public int getMergedSegments() {
        if (this.merger.isDone()) {
            return this.merger.getSegmentsCount() - 1;
        }
        return this.merger.getSegmentsCount();
    }

    @Override
    public void close() {
        this.targetProcess.destroyForcibly();
    }

    public MergedOutputPiper(ProcessBuilder childProcessBuilder) {
        this.childProcessBuilder = childProcessBuilder;
    }
}

