/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.utilities.consumer;

import com.amazonaws.kinesisvideo.parser.utilities.consumer.GetMediaResponseStreamConsumer;
import com.amazonaws.kinesisvideo.parser.utilities.consumer.GetMediaResponseStreamConsumerFactory;
import com.amazonaws.kinesisvideo.parser.utilities.consumer.MergedOutputPiper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class MergedOutputPiperFactory
extends GetMediaResponseStreamConsumerFactory {
    private final Optional<String> directoryOptional;
    private final List<String> commandList;
    private final boolean redirectOutputAndError;

    public MergedOutputPiperFactory(String ... commands) {
        this(Optional.empty(), commands);
    }

    public MergedOutputPiperFactory(Optional<String> directoryOptional, String ... commands) {
        this(directoryOptional, false, commands);
    }

    private MergedOutputPiperFactory(Optional<String> directoryOptional, boolean redirectOutputAndError, String ... commands) {
        this.directoryOptional = directoryOptional;
        this.commandList = new ArrayList<String>();
        for (String command : commands) {
            this.commandList.add(command);
        }
        this.redirectOutputAndError = redirectOutputAndError;
    }

    public MergedOutputPiperFactory(Optional<String> directoryOptional, boolean redirectOutputAndError, List<String> commandList) {
        this.directoryOptional = directoryOptional;
        this.commandList = commandList;
        this.redirectOutputAndError = redirectOutputAndError;
    }

    @Override
    public GetMediaResponseStreamConsumer createConsumer() throws IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]).command(this.commandList);
        this.directoryOptional.ifPresent(d -> builder.directory(new File((String)d)));
        if (this.redirectOutputAndError) {
            builder.redirectOutput(Files.createFile(Paths.get(this.redirectedFileName("stdout"), new String[0]), new FileAttribute[0]).toFile());
            builder.redirectError(Files.createFile(Paths.get(this.redirectedFileName("stderr"), new String[0]), new FileAttribute[0]).toFile());
        }
        return new MergedOutputPiper(builder);
    }

    private String redirectedFileName(String suffix) {
        return "MergedOutputPiper-" + System.currentTimeMillis() + "-" + suffix;
    }
}

