/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.neptune.gremlin.driver.sigv4;

import com.amazon.neptune.gremlin.driver.exception.SigV4PropertiesNotFoundException;
import com.amazon.neptune.gremlin.driver.sigv4.SigV4Properties;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedSigV4PropertiesProvider {
    private static final Logger log = LoggerFactory.getLogger(ChainedSigV4PropertiesProvider.class);
    private final Supplier<SigV4Properties>[] providers;

    public ChainedSigV4PropertiesProvider() {
        this.providers = new Supplier[]{this::getSigV4PropertiesFromEnv, this::getSigV4PropertiesFromSystem};
    }

    public ChainedSigV4PropertiesProvider(Supplier<SigV4Properties>[] providers) {
        this.providers = new Supplier[providers.length];
        System.arraycopy(providers, 0, this.providers, 0, providers.length);
    }

    public SigV4Properties getSigV4Properties() throws SigV4PropertiesNotFoundException {
        for (Supplier<SigV4Properties> provider : this.providers) {
            try {
                SigV4Properties properties = provider.get();
                log.info("Successfully loaded SigV4 properties from provider: {}", provider.getClass());
                return properties;
            }
            catch (SigV4PropertiesNotFoundException e) {
                log.info("Unable to load SigV4 properties from provider: {}", provider.getClass());
            }
        }
        String message = "Unable to load SigV4 properties from any of the providers";
        log.warn("Unable to load SigV4 properties from any of the providers");
        throw new SigV4PropertiesNotFoundException("Unable to load SigV4 properties from any of the providers");
    }

    public SigV4Properties getSigV4PropertiesFromEnv() throws SigV4PropertiesNotFoundException {
        String serviceRegion = StringUtils.trim((String)System.getenv("SERVICE_REGION"));
        if (StringUtils.isBlank((CharSequence)serviceRegion)) {
            String msg = "SigV4 properties not found as a environment variable";
            log.info("SigV4 properties not found as a environment variable");
            throw new SigV4PropertiesNotFoundException("SigV4 properties not found as a environment variable");
        }
        return new SigV4Properties(serviceRegion);
    }

    public SigV4Properties getSigV4PropertiesFromSystem() {
        String serviceRegion = StringUtils.trim((String)System.getProperty("SERVICE_REGION"));
        if (StringUtils.isBlank((CharSequence)serviceRegion)) {
            String msg = "SigV4 properties not found in system properties";
            log.info("SigV4 properties not found in system properties");
            throw new SigV4PropertiesNotFoundException("SigV4 properties not found in system properties");
        }
        return new SigV4Properties(serviceRegion);
    }
}

