/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.neptune.auth;

import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.neptune.auth.NeptuneSigV4SignerBase;
import com.amazonaws.neptune.auth.NeptuneSigV4SignerException;
import com.amazonaws.util.StringUtils;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.http.entity.StringEntity;

public class NeptuneNettyHttpSigV4Signer
extends NeptuneSigV4SignerBase<FullHttpRequest> {
    public NeptuneNettyHttpSigV4Signer(String regionName, AWSCredentialsProvider awsCredentialsProvider) throws NeptuneSigV4SignerException {
        super(regionName, awsCredentialsProvider);
    }

    @Override
    protected SignableRequest<?> toSignableRequest(FullHttpRequest request) throws NeptuneSigV4SignerException {
        InputStream content;
        this.checkNotNull(request, "The request must not be null");
        this.checkNotNull(request.uri(), "The request URI must not be null");
        this.checkNotNull(request.method(), "The request method must not be null");
        HttpHeaders headers = request.headers();
        HashMap<String, String> headersInternal = new HashMap<String, String>();
        String hostName = "";
        for (String header : headers.names()) {
            if (!header.equalsIgnoreCase("Host")) {
                headersInternal.put(header, headers.get(header));
                continue;
            }
            hostName = headers.get(header);
        }
        URI uri = URI.create(request.uri());
        String queryStr = uri.getQuery();
        HashMap<String, List<String>> parametersInternal = new HashMap<String, List<String>>(this.extractParametersFromQueryString(queryStr));
        ByteBuf contentBuffer = request.content();
        boolean hasContent = false;
        try {
            if (contentBuffer != null && contentBuffer.isReadable()) {
                hasContent = true;
                contentBuffer.retain();
                byte[] bytes = new byte[contentBuffer.readableBytes()];
                contentBuffer.getBytes(contentBuffer.readerIndex(), bytes);
                content = new ByteArrayInputStream(bytes);
            } else {
                content = new StringEntity("").getContent();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new NeptuneSigV4SignerException("Encoding of the input string failed", e);
        }
        catch (IOException e) {
            throw new NeptuneSigV4SignerException("IOException while accessing entity content", e);
        }
        finally {
            if (hasContent) {
                contentBuffer.release();
            }
        }
        if (StringUtils.isNullOrEmpty((String)hostName)) {
            String authority = uri.getAuthority();
            if (authority == null) {
                throw new NeptuneSigV4SignerException("Unable to identify host information, either hostname should be provided in the uri or should be passed as a header");
            }
            hostName = authority;
        }
        URI endpointUri = URI.create("http://" + hostName);
        return this.convertToSignableRequest(request.method().name(), endpointUri, uri.getPath(), headersInternal, parametersInternal, content);
    }

    @Override
    protected void attachSignature(FullHttpRequest request, NeptuneSigV4SignerBase.NeptuneSigV4Signature signature) throws NeptuneSigV4SignerException {
        this.checkNotNull(signature, "The signature must not be null");
        this.checkNotNull(signature.getHostHeader(), "The signed Host header must not be null");
        this.checkNotNull(signature.getXAmzDateHeader(), "The signed X-AMZ-DATE header must not be null");
        this.checkNotNull(signature.getAuthorizationHeader(), "The signed Authorization header must not be null");
        HttpHeaders headers = request.headers();
        Optional<String> hostHeaderName = Optional.empty();
        for (String name2 : headers.names()) {
            if (!name2.equalsIgnoreCase("Host")) continue;
            hostHeaderName = Optional.of(name2);
            break;
        }
        hostHeaderName.ifPresent(name -> headers.remove(name));
        request.headers().add("Host", (Object)signature.getHostHeader());
        request.headers().add("X-Amz-Date", (Object)signature.getXAmzDateHeader());
        request.headers().add("Authorization", (Object)signature.getAuthorizationHeader());
        if (!signature.getSessionToken().isEmpty()) {
            request.headers().add("X-Amz-Security-Token", (Object)signature.getSessionToken());
        }
    }
}

