/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.neptune.client.jena;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.neptune.auth.NeptuneApacheHttpSigV4Signer;
import com.amazonaws.neptune.auth.NeptuneSigV4SignerException;
import com.amazonaws.util.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.rdfconnection.RDFConnectionRemoteBuilder;

public class NeptuneJenaSigV4Example {
    public static void main(String ... args) throws NeptuneSigV4SignerException {
        if (args.length == 0 || StringUtils.isNullOrEmpty((String)args[0])) {
            System.err.println("Please specify your endpoint as program argument (e.g.: http://<your_neptune_endpoint>:<your_neptune_endpoint>)");
            System.exit(1);
        }
        String endpoint = args[0];
        String regionName = "us-east-1";
        DefaultAWSCredentialsProviderChain awsCredentialsProvider = new DefaultAWSCredentialsProviderChain();
        final NeptuneApacheHttpSigV4Signer v4Signer = new NeptuneApacheHttpSigV4Signer("us-east-1", (AWSCredentialsProvider)awsCredentialsProvider);
        CloseableHttpClient v4SigningClient = HttpClientBuilder.create().addInterceptorLast(new HttpRequestInterceptor(){

            public void process(HttpRequest req, HttpContext ctx) throws HttpException {
                if (req instanceof HttpUriRequest) {
                    HttpUriRequest httpUriReq = (HttpUriRequest)req;
                    try {
                        v4Signer.signRequest((Object)httpUriReq);
                    }
                    catch (NeptuneSigV4SignerException e) {
                        throw new HttpException("Problem signing the request: ", (Throwable)e);
                    }
                } else {
                    throw new HttpException("Not an HttpUriRequest");
                }
            }
        }).build();
        RDFConnectionRemoteBuilder builder = RDFConnectionRemote.create().httpClient((HttpClient)v4SigningClient).destination(endpoint).queryEndpoint("sparql").updateEndpoint("sparql");
        String query = "SELECT * { ?s ?p ?o } LIMIT 100";
        try (RDFConnection conn = builder.build();){
            System.out.println("> Printing query result: ");
            conn.querySelect(query, System.out::println);
        }
    }
}

