/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.neptune.client.rdf4j;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.neptune.auth.NeptuneSigV4SignerException;
import com.amazonaws.neptune.client.rdf4j.NeptuneSparqlRepository;
import com.amazonaws.util.StringUtils;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;

public final class NeptuneRdf4JSigV4Example {
    private static final String TEST_REGION = "us-east-1";
    private static final String SAMPLE_QUERY = "SELECT * WHERE { ?s ?p ?o } LIMIT 10";
    private static final String SAMPLE_UPDATE = "INSERT DATA { <http://Alice> <http://knows> <http://Bob> }";
    static final String ACCESS_DENIED_MSG = "{\"status\":\"403 Forbidden\",\"message\":\"Access Denied!\"}";

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || StringUtils.isNullOrEmpty((String)args[0])) {
            System.err.println("Please specify your endpoint as program argument (e.g.: http://<my_neptune_host>:<my_neptune_port>)");
            System.exit(1);
        }
        String endpoint = args[0];
        String query = args.length > 1 && !StringUtils.isNullOrEmpty((String)args[1]) ? args[1] : SAMPLE_QUERY;
        NeptuneRdf4JSigV4Example.executeSignedQueryRequest(endpoint, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void executeSignedQueryRequest(String endpointUrl, String query) throws NeptuneSigV4SignerException {
        DefaultAWSCredentialsProviderChain awsCredentialsProvider = new DefaultAWSCredentialsProviderChain();
        NeptuneSparqlRepository neptuneSparqlRepo = new NeptuneSparqlRepository(endpointUrl, (AWSCredentialsProvider)awsCredentialsProvider, TEST_REGION);
        try {
            neptuneSparqlRepo.initialize();
            NeptuneRdf4JSigV4Example.evaluateAndPrintQueryResult(query, (Repository)neptuneSparqlRepo);
        }
        finally {
            neptuneSparqlRepo.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void executeSignedInsertRequest(String endpointUrl) throws NeptuneSigV4SignerException {
        DefaultAWSCredentialsProviderChain awsCredentialsProvider = new DefaultAWSCredentialsProviderChain();
        NeptuneSparqlRepository neptuneSparqlRepo = new NeptuneSparqlRepository(endpointUrl, (AWSCredentialsProvider)awsCredentialsProvider, TEST_REGION);
        try {
            neptuneSparqlRepo.initialize();
            try (RepositoryConnection conn = neptuneSparqlRepo.getConnection();){
                Update update = conn.prepareUpdate(SAMPLE_UPDATE);
                update.execute();
                System.out.println("Update query executed!");
            }
        }
        finally {
            neptuneSparqlRepo.shutDown();
        }
    }

    protected static void executeUnsignedQueryRequest(String endpointUrl) {
        NeptuneSparqlRepository neptuneSparqlRepo = new NeptuneSparqlRepository(endpointUrl);
        try {
            neptuneSparqlRepo.initialize();
            NeptuneRdf4JSigV4Example.evaluateAndPrintQueryResult(SAMPLE_QUERY, (Repository)neptuneSparqlRepo);
        }
        finally {
            neptuneSparqlRepo.shutDown();
        }
    }

    protected static void evaluateAndPrintQueryResult(String queryString, Repository repo) {
        try (RepositoryConnection conn = repo.getConnection();){
            TupleQuery query = conn.prepareTupleQuery(queryString);
            System.out.println("> Printing query result: ");
            TupleQueryResult res = query.evaluate();
            while (res.hasNext()) {
                System.err.println("{");
                BindingSet bs = (BindingSet)res.next();
                boolean first = true;
                for (String varName : bs.getBindingNames()) {
                    if (first) {
                        System.out.print("  { ");
                    } else {
                        System.out.print(", ");
                    }
                    System.out.print("?" + varName + " -> " + bs.getBinding(varName));
                    first = false;
                }
                System.out.println("}");
                System.out.println("}");
            }
        }
    }

    private NeptuneRdf4JSigV4Example() {
    }
}

