/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.neptune.client.rdf4j;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.neptune.auth.NeptuneApacheHttpSigV4Signer;
import com.amazonaws.neptune.auth.NeptuneSigV4Signer;
import com.amazonaws.neptune.auth.NeptuneSigV4SignerException;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.eclipse.rdf4j.repository.sparql.SPARQLRepository;

public class NeptuneSparqlRepository
extends SPARQLRepository {
    private final String endpointUrl;
    private final String regionName;
    private final boolean authenticationEnabled;
    private final AWSCredentialsProvider awsCredentialsProvider;
    private NeptuneSigV4Signer<HttpUriRequest> v4Signer;

    public NeptuneSparqlRepository(String endpointUrl) {
        super(NeptuneSparqlRepository.getSparqlEndpoint(endpointUrl));
        this.authenticationEnabled = false;
        this.endpointUrl = null;
        this.awsCredentialsProvider = null;
        this.regionName = null;
    }

    public NeptuneSparqlRepository(String endpointUrl, AWSCredentialsProvider awsCredentialsProvider, String regionName) throws NeptuneSigV4SignerException {
        super(NeptuneSparqlRepository.getSparqlEndpoint(endpointUrl));
        this.authenticationEnabled = true;
        this.endpointUrl = endpointUrl;
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.regionName = regionName;
        this.initAuthenticatingHttpClient();
    }

    protected void initAuthenticatingHttpClient() throws NeptuneSigV4SignerException {
        if (!this.authenticationEnabled) {
            return;
        }
        this.v4Signer = new NeptuneApacheHttpSigV4Signer(this.regionName, this.awsCredentialsProvider);
        CloseableHttpClient v4SigningClient = HttpClientBuilder.create().addInterceptorLast(new HttpRequestInterceptor(){

            public void process(HttpRequest req, HttpContext ctx) throws HttpException, IOException {
                if (req instanceof HttpUriRequest) {
                    HttpUriRequest httpUriReq = (HttpUriRequest)req;
                    try {
                        NeptuneSparqlRepository.this.v4Signer.signRequest((Object)httpUriReq);
                    }
                    catch (NeptuneSigV4SignerException e) {
                        throw new HttpException("Problem signing the request: ", (Throwable)e);
                    }
                } else {
                    throw new HttpException("Not an HttpUriRequest");
                }
            }
        }).build();
        this.setHttpClient((HttpClient)v4SigningClient);
    }

    private static String getSparqlEndpoint(String endpointUrl) {
        return endpointUrl + "/sparql";
    }
}

