/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.integ;

import com.amazonaws.athena.connector.integ.data.ConnectorPackagingAttributes;
import com.amazonaws.athena.connector.integ.data.ConnectorStackAttributes;
import com.amazonaws.athena.connector.integ.data.ConnectorVpcAttributes;
import com.amazonaws.athena.connector.integ.data.TestConfig;
import com.amazonaws.athena.connector.integ.providers.ConnectorEnvironmentVarsProvider;
import com.amazonaws.athena.connector.integ.providers.ConnectorPackagingAttributesProvider;
import com.amazonaws.athena.connector.integ.providers.ConnectorVpcAttributesProvider;
import java.util.Map;
import java.util.Optional;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.iam.PolicyDocument;

public class ConnectorStackAttributesProvider {
    private final Construct scope;
    private final String id;
    private final String lambdaFunctionName;
    private final TestConfig testConfig;
    private final Optional<PolicyDocument> connectorAccessPolicy;
    private final Map<String, String> environmentVariables;
    private final ConnectorPackagingAttributes connectorPackagingAttributes;
    private final Optional<ConnectorVpcAttributes> connectorVpcAttributes;

    protected ConnectorStackAttributesProvider(Construct scope, String id, String lambdaFunctionName, TestConfig testConfig, Optional<PolicyDocument> connectorAccessPolicy, Map<String, String> environmentVariables) {
        this.scope = scope;
        this.id = id;
        this.lambdaFunctionName = lambdaFunctionName;
        this.testConfig = testConfig;
        this.connectorAccessPolicy = connectorAccessPolicy;
        this.connectorPackagingAttributes = ConnectorPackagingAttributesProvider.getAttributes();
        this.connectorVpcAttributes = ConnectorVpcAttributesProvider.getAttributes(testConfig);
        this.environmentVariables = ConnectorEnvironmentVarsProvider.getVars(testConfig);
        this.environmentVariables.putAll(environmentVariables);
    }

    protected ConnectorStackAttributes getAttributes() {
        return new ConnectorStackAttributes(this.scope, this.id, this.lambdaFunctionName, this.connectorAccessPolicy, this.environmentVariables, this.connectorPackagingAttributes, this.connectorVpcAttributes);
    }
}

