/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.integ;

import com.amazonaws.athena.connector.integ.data.ConnectorStackAttributes;
import com.amazonaws.athena.connector.integ.stacks.ConnectorStack;
import com.amazonaws.athena.connector.integ.stacks.ConnectorWithVpcStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awscdk.core.Stack;

public class ConnectorStackFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConnectorStackFactory.class);
    private final ConnectorStackAttributes attributes;
    private final boolean isSupportedVpcConfig;

    public ConnectorStackFactory(ConnectorStackAttributes attributes) {
        this.attributes = attributes;
        this.isSupportedVpcConfig = attributes.getConnectorVpcAttributes().isPresent();
    }

    public Stack createStack() {
        if (this.isSupportedVpcConfig) {
            logger.info("Creating stack: ConnectorWithVpcStack");
            return ConnectorWithVpcStack.buildWithAttributes(this.attributes);
        }
        logger.info("Creating stack: ConnectorStack");
        return ConnectorStack.buildWithAttributes(this.attributes);
    }
}

