/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.integ;

import com.amazonaws.athena.connector.integ.ConnectorStackAttributesProvider;
import com.amazonaws.athena.connector.integ.ConnectorStackFactory;
import com.amazonaws.athena.connector.integ.data.TestConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.testng.internal.collections.Pair;
import software.amazon.awscdk.core.App;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Stack;
import software.amazon.awscdk.services.iam.PolicyDocument;

public abstract class ConnectorStackProvider {
    private static final int LAMBDA_FUNCTION_MAX_LENGTH = 64;
    private final String cloudFormationStackName;
    private final TestConfig testConfig;
    private final App theApp;
    private final String lambdaFunctionName;

    public ConnectorStackProvider(String stackName, TestConfig testConfig) {
        String randomUuidStr = UUID.randomUUID().toString();
        this.theApp = new App();
        this.cloudFormationStackName = String.format("integration-%s-%s", stackName, randomUuidStr);
        this.lambdaFunctionName = String.format("%s_%s", stackName.toLowerCase(), randomUuidStr.replace('-', '_')).substring(0, Math.min(64, stackName.length() + randomUuidStr.length() + 1));
        this.testConfig = testConfig;
    }

    protected abstract Optional<PolicyDocument> getAccessPolicy();

    protected abstract void setEnvironmentVars(Map var1);

    protected abstract void setSpecificResource(Stack var1);

    protected String getLambdaFunctionName() {
        return this.lambdaFunctionName;
    }

    protected Pair<App, Stack> getStack() {
        ConnectorStackAttributesProvider attributesProvider = new ConnectorStackAttributesProvider((Construct)this.theApp, this.cloudFormationStackName, this.lambdaFunctionName, this.testConfig, this.getAccessPolicy(), this.getEnvironmentVars());
        ConnectorStackFactory stackFactory = new ConnectorStackFactory(attributesProvider.getAttributes());
        Stack theStack = stackFactory.createStack();
        this.setSpecificResource(theStack);
        return new Pair((Object)this.theApp, (Object)theStack);
    }

    private Map<String, String> getEnvironmentVars() {
        HashMap<String, String> environmentVars = new HashMap<String, String>();
        this.setEnvironmentVars(environmentVars);
        return environmentVars;
    }
}

