/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.integ;

import com.amazonaws.athena.connector.integ.ConnectorStackProvider;
import com.amazonaws.athena.connector.integ.clients.CloudFormationClient;
import com.amazonaws.athena.connector.integ.data.ConnectorVpcAttributes;
import com.amazonaws.athena.connector.integ.data.SecretsManagerCredentials;
import com.amazonaws.athena.connector.integ.data.TestConfig;
import com.amazonaws.athena.connector.integ.providers.ConnectorVpcAttributesProvider;
import com.amazonaws.athena.connector.integ.providers.SecretsManagerCredentialsProvider;
import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.athena.AmazonAthenaClientBuilder;
import com.amazonaws.services.athena.model.Datum;
import com.amazonaws.services.athena.model.GetQueryExecutionRequest;
import com.amazonaws.services.athena.model.GetQueryExecutionResult;
import com.amazonaws.services.athena.model.GetQueryResultsRequest;
import com.amazonaws.services.athena.model.GetQueryResultsResult;
import com.amazonaws.services.athena.model.ListDatabasesRequest;
import com.amazonaws.services.athena.model.ListDatabasesResult;
import com.amazonaws.services.athena.model.ResultConfiguration;
import com.amazonaws.services.athena.model.Row;
import com.amazonaws.services.athena.model.StartQueryExecutionRequest;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import software.amazon.awscdk.core.Stack;
import software.amazon.awscdk.services.iam.PolicyDocument;

public abstract class IntegrationTestBase {
    private static final Logger logger = LoggerFactory.getLogger(IntegrationTestBase.class);
    private static final String TEST_CONFIG_WORK_GROUP = "athena_work_group";
    private static final String TEST_CONFIG_RESULT_LOCATION = "athena_result_location";
    private static final String TEST_CONFIG_USER_SETTINGS = "user_settings";
    private static final String ATHENA_QUERY_QUEUED_STATE = "QUEUED";
    private static final String ATHENA_QUERY_RUNNING_STATE = "RUNNING";
    private static final String ATHENA_QUERY_FAILED_STATE = "FAILED";
    private static final String ATHENA_QUERY_CANCELLED_STATE = "CANCELLED";
    protected static final String INTEG_TEST_DATABASE_NAME = "datatypes";
    protected static final String TEST_NULL_TABLE_NAME = "null_table";
    protected static final String TEST_EMPTY_TABLE_NAME = "empty_table";
    protected static final String TEST_DATATYPES_TABLE_NAME = "datatypes_table";
    protected static final int TEST_DATATYPES_INT_VALUE = Integer.MIN_VALUE;
    protected static final short TEST_DATATYPES_SHORT_VALUE = Short.MIN_VALUE;
    protected static final long TEST_DATATYPES_LONG_VALUE = Long.MIN_VALUE;
    protected static final String TEST_DATATYPES_VARCHAR_VALUE = "John Doe";
    protected static final boolean TEST_DATATYPES_BOOLEAN_VALUE = true;
    protected static final float TEST_DATATYPES_SINGLE_PRECISION_VALUE = 1.0E-37f;
    protected static final double TEST_DATATYPES_DOUBLE_PRECISION_VALUE = 1.0E-307;
    protected static final String TEST_DATATYPES_DATE_VALUE = "2013-06-01";
    protected static final String TEST_DATATYPES_TIMESTAMP_VALUE = "2016-06-22T19:10:25";
    protected static final byte[] TEST_DATATYPES_BYTE_ARRAY_VALUE = new byte[]{-34, -83, -66, -17};
    protected static final String TEST_DATATYPES_VARCHAR_ARRAY_VALUE = "[(408)-589-5846, (408)-589-5555]";
    private static final long sleepTimeMillis = 5000L;
    private final ConnectorStackProvider connectorStackProvider;
    private final String lambdaFunctionName;
    private final AmazonAthena athenaClient;
    private final TestConfig testConfig = new TestConfig();
    private final Optional<ConnectorVpcAttributes> vpcAttributes = ConnectorVpcAttributesProvider.getAttributes(this.testConfig);
    private final Optional<SecretsManagerCredentials> secretCredentials = SecretsManagerCredentialsProvider.getCredentials(this.testConfig);
    private final String athenaWorkgroup;
    private final String athenaResultLocation;
    private CloudFormationClient cloudFormationClient;

    public IntegrationTestBase() {
        this.connectorStackProvider = new ConnectorStackProvider(this.getClass().getSimpleName(), this.testConfig){

            @Override
            protected Optional<PolicyDocument> getAccessPolicy() {
                return IntegrationTestBase.this.getConnectorAccessPolicy();
            }

            @Override
            protected void setEnvironmentVars(Map environmentVars) {
                IntegrationTestBase.this.setConnectorEnvironmentVars(environmentVars);
            }

            @Override
            protected void setSpecificResource(Stack stack) {
                IntegrationTestBase.this.setUpStackData(stack);
            }
        };
        this.lambdaFunctionName = this.connectorStackProvider.getLambdaFunctionName();
        this.athenaClient = AmazonAthenaClientBuilder.defaultClient();
        this.athenaWorkgroup = this.getAthenaWorkgroup();
        this.athenaResultLocation = this.getAthenaResultLocation();
    }

    private String getAthenaWorkgroup() throws RuntimeException {
        String athenaWorkgroup = this.testConfig.getStringItem(TEST_CONFIG_WORK_GROUP).orElseThrow(() -> new RuntimeException("athena_work_group must be specified in test-config.json."));
        logger.info("Athena Workgroup: {}", (Object)athenaWorkgroup);
        return athenaWorkgroup;
    }

    private String getAthenaResultLocation() throws RuntimeException {
        String athenaResultLocation = "s3://" + this.testConfig.getStringItem(TEST_CONFIG_RESULT_LOCATION).orElseThrow(() -> new RuntimeException("athena_result_location must be specified in test-config.json."));
        logger.info("Athena Result Location: {}", (Object)athenaResultLocation);
        return athenaResultLocation;
    }

    public String getLambdaFunctionName() {
        return this.lambdaFunctionName;
    }

    public Optional<ConnectorVpcAttributes> getVpcAttributes() {
        return this.vpcAttributes;
    }

    public Optional<Map<String, Object>> getUserSettings() {
        return this.testConfig.getMap(TEST_CONFIG_USER_SETTINGS);
    }

    public Optional<SecretsManagerCredentials> getSecretCredentials() {
        return this.secretCredentials;
    }

    protected abstract void setUpTableData() throws Exception;

    protected abstract void setUpStackData(Stack var1);

    protected abstract void setConnectorEnvironmentVars(Map<String, String> var1);

    protected abstract Optional<PolicyDocument> getConnectorAccessPolicy();

    @BeforeClass
    protected void setUp() throws Exception {
        this.cloudFormationClient = new CloudFormationClient(this.connectorStackProvider.getStack());
        try {
            this.cloudFormationClient.createStack();
            this.setUpTableData();
        }
        catch (Exception e) {
            this.cloudFormationClient.deleteStack();
            throw e;
        }
    }

    @AfterClass
    protected void cleanUp() {
        this.cloudFormationClient.deleteStack();
    }

    public List<String> listDatabases() {
        logger.info("listDatabases({})", (Object)this.lambdaFunctionName);
        ListDatabasesRequest listDatabasesRequest = new ListDatabasesRequest().withCatalogName(this.lambdaFunctionName);
        ListDatabasesResult listDatabasesResult = this.athenaClient.listDatabases(listDatabasesRequest);
        logger.info("Results: [{}]", (Object)listDatabasesResult);
        ArrayList<String> dbNames = new ArrayList<String>();
        listDatabasesResult.getDatabaseList().forEach(db -> dbNames.add(db.getName()));
        return dbNames;
    }

    public List<String> listTables(String databaseName) throws RuntimeException {
        String query = String.format("show tables in `%s`.`%s`;", this.lambdaFunctionName, databaseName);
        ArrayList<String> tableNames = new ArrayList<String>();
        this.startQueryExecution(query).getResultSet().getRows().forEach(row -> tableNames.add(((Datum)row.getData().get(0)).getVarCharValue()));
        return tableNames;
    }

    public Map<String, String> describeTable(String databaseName, String tableName) throws RuntimeException {
        String query = String.format("describe `%s`.`%s`.`%s`;", this.lambdaFunctionName, databaseName, tableName);
        HashMap<String, String> schema = new HashMap<String, String>();
        this.startQueryExecution(query).getResultSet().getRows().forEach(row -> {
            String property = ((Datum)row.getData().get(0)).getVarCharValue();
            String[] columnProperties = property.split("\t");
            if (columnProperties.length == 2) {
                schema.put(columnProperties[0], columnProperties[1]);
            }
        });
        return schema;
    }

    public GetQueryResultsResult startQueryExecution(String query) throws RuntimeException {
        StartQueryExecutionRequest startQueryExecutionRequest = new StartQueryExecutionRequest().withWorkGroup(this.athenaWorkgroup).withQueryString(query).withResultConfiguration(new ResultConfiguration().withOutputLocation(this.athenaResultLocation));
        String queryExecutionId = this.sendAthenaQuery(startQueryExecutionRequest);
        logger.info("Query: [{}], Query Id: [{}]", (Object)query, (Object)queryExecutionId);
        this.waitForAthenaQueryResults(queryExecutionId);
        GetQueryResultsResult getQueryResultsResult = this.getAthenaQueryResults(queryExecutionId);
        return getQueryResultsResult;
    }

    private String sendAthenaQuery(StartQueryExecutionRequest startQueryExecutionRequest) {
        return this.athenaClient.startQueryExecution(startQueryExecutionRequest).getQueryExecutionId();
    }

    private void waitForAthenaQueryResults(String queryExecutionId) throws RuntimeException {
        String queryState;
        GetQueryExecutionResult getQueryExecutionResult;
        GetQueryExecutionRequest getQueryExecutionRequest = new GetQueryExecutionRequest().withQueryExecutionId(queryExecutionId);
        while (true) {
            getQueryExecutionResult = this.athenaClient.getQueryExecution(getQueryExecutionRequest);
            queryState = getQueryExecutionResult.getQueryExecution().getStatus().getState();
            logger.info("Query State: {}", (Object)queryState);
            if (!queryState.equals(ATHENA_QUERY_QUEUED_STATE) && !queryState.equals(ATHENA_QUERY_RUNNING_STATE)) break;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread.sleep interrupted: " + e.getMessage(), e);
            }
        }
        if (queryState.equals(ATHENA_QUERY_FAILED_STATE) || queryState.equals(ATHENA_QUERY_CANCELLED_STATE)) {
            throw new RuntimeException(getQueryExecutionResult.getQueryExecution().getStatus().getStateChangeReason());
        }
    }

    private GetQueryResultsResult getAthenaQueryResults(String queryExecutionId) {
        GetQueryResultsRequest getQueryResultsRequest = new GetQueryResultsRequest().withQueryExecutionId(queryExecutionId);
        return this.athenaClient.getQueryResults(getQueryResultsRequest);
    }

    public List<String> fetchDataSelect(String schemaName, String tablename, String lambdaFnName) throws RuntimeException {
        return this.processQuery(String.format("select * from   \"lambda:%s\".\"%s\".\"%s\";", lambdaFnName, schemaName, tablename));
    }

    public List<String> fetchDataSelectCountAll(String schemaName, String tablename, String lambdaFnName) throws RuntimeException {
        return this.processQuery(String.format("select count(*) from   \"lambda:%s\".\"%s\".\"%s\";", lambdaFnName, schemaName, tablename));
    }

    public List<String> fetchDataWhereClause(String schemaName, String tablename, String lambdaFnName, String whereClauseColumn, String whereClauseValue) throws RuntimeException {
        return this.processQuery(String.format("select * from   \"lambda:%s\".\"%s\".\"%s\" where \"%s\" = '%s' ;", lambdaFnName, schemaName, tablename, whereClauseColumn, whereClauseValue));
    }

    public List<String> fetchDataWhereClauseLIKE(String schemaName, String tablename, String lambdaFnName, String whereClauseColumn, String whereClauseValue) throws RuntimeException {
        return this.processQuery(String.format("select * from   \"lambda:%s\".\"%s\".\"%s\" where \"%s\" LIKE '%s' ;", lambdaFnName, schemaName, tablename, whereClauseColumn, whereClauseValue));
    }

    public List<String> fetchDataGroupBy(String schemaName, String tablename, String lambdaFnName, String groupByColumn) throws RuntimeException {
        return this.processQuery(String.format("select count(\"%s\") from   \"lambda:%s\".\"%s\".\"%s\" group by \"%s\";", groupByColumn, lambdaFnName, schemaName, tablename, groupByColumn));
    }

    public List<String> fetchDataGroupByHavingClause(String schemaName, String tablename, String lambdaFnName, String groupByColumn, String groupByColumnValue) throws RuntimeException {
        return this.processQuery(String.format("select count('%s') from   \"lambda:%s\".\"%s\".\"%s\" group by %s having %s = '%s' ;", groupByColumn, lambdaFnName, schemaName, tablename, groupByColumn, groupByColumn, groupByColumnValue));
    }

    public List<String> fetchDataUnion(String schemaName, String tablename1, String tablename2, String lambdaFnName1, String lambdaFnName2, String whereClauseColumn, String whereClauseValue) throws RuntimeException {
        return this.processQuery(String.format("select * from   \"lambda:%s\".\"%s\".\"%s\" union all select * from   \"lambda:%s\".\"%s\".\"%s\" where \"%s\" = '%s' ;", lambdaFnName1, schemaName, tablename1, lambdaFnName2, schemaName, tablename2, whereClauseColumn, whereClauseValue));
    }

    public List<String> fetchDataDistinct(String lambdaFnName, String schemaName, String tablename, String distinctColumn, String whereClauseColumn, String whereClauseValue) {
        return this.processQuery(String.format("select distinct (%s) from  \"lambda:%s\".\"%s\".\"%s\" where \"%s\" = %s ;", distinctColumn, lambdaFnName, schemaName, tablename, whereClauseColumn, whereClauseValue));
    }

    public List<String> fetchDataJoin(String lambdaFnName1, String schemaName1, String tablename1, String lambdaFnName2, String schemaName2, String tablename2, String whereClauseColumn1, String whereClauseColumn2) throws RuntimeException {
        return this.processQuery(String.format("select * from   \"lambda:%s\".\"%s\".\"%s\" t1,  \"lambda:%s\".\"%s\".\"%s\" t2 where t1.\"%s\" = t2.\"%s\" ;", lambdaFnName1, schemaName1, tablename1, lambdaFnName2, schemaName2, tablename2, whereClauseColumn1, whereClauseColumn2));
    }

    public float calculateThroughput(String lambdaFnName, String schemaName, String tableName) {
        logger.info("Executing calculateThroughput");
        logger.info("Connector Lambda Name:" + lambdaFnName);
        logger.info("Schema Name :" + schemaName);
        logger.info("Table Name :" + tableName);
        List<String> list = this.fetchDataSelectCountAll(schemaName, tableName, lambdaFnName);
        long numberOfRecords = Long.valueOf(list.get(0).toString());
        logger.info("Total Record count:" + numberOfRecords);
        long startTimeInMillis = System.currentTimeMillis();
        this.fetchDataSelect(schemaName, tableName, lambdaFnName);
        long endTimeInMillis = System.currentTimeMillis();
        float elapsedSeconds = (float)(endTimeInMillis - startTimeInMillis) / 1000.0f;
        logger.info("Total time taken in seconds : " + elapsedSeconds);
        float throughput = (float)numberOfRecords / elapsedSeconds;
        logger.info("Total throughput(Records per Second) :" + throughput);
        return throughput;
    }

    public List<String> processQuery(String query) {
        ArrayList<String> firstColValues = new ArrayList<String>();
        this.skipColumnHeaderRow(this.startQueryExecution(query).getResultSet().getRows()).forEach(row -> firstColValues.add(((Datum)row.getData().get(0)).getVarCharValue()));
        return firstColValues;
    }

    public List<Row> skipColumnHeaderRow(List<Row> rows) {
        if (!rows.isEmpty()) {
            rows.remove(0);
        }
        return rows;
    }

    @Test
    public void selectIntegerTypeTest() {
        logger.info("--------------------------------------");
        logger.info("Executing selectIntegerTypeTest");
        logger.info("--------------------------------------");
        String query = String.format("select int_type from %s.%s.%s;", this.lambdaFunctionName, INTEG_TEST_DATABASE_NAME, TEST_DATATYPES_TABLE_NAME);
        List rows = this.startQueryExecution(query).getResultSet().getRows();
        if (!rows.isEmpty()) {
            rows.remove(0);
        }
        ArrayList values = new ArrayList();
        rows.forEach(row -> values.add(Integer.parseInt(((Datum)row.getData().get(0)).getVarCharValue().split("\\.")[0])));
        logger.info("Titles: {}", values);
        AssertJUnit.assertEquals((String)"Wrong number of DB records found.", (int)1, (int)values.size());
        AssertJUnit.assertTrue((String)"Integer not found: -2147483648", (boolean)values.contains(Integer.MIN_VALUE));
    }

    @Test
    public void selectVarcharTypeTest() {
        logger.info("--------------------------------------");
        logger.info("Executing selectVarcharTypeTest");
        logger.info("--------------------------------------");
        String query = String.format("select varchar_type from %s.%s.%s;", this.lambdaFunctionName, INTEG_TEST_DATABASE_NAME, TEST_DATATYPES_TABLE_NAME);
        List rows = this.startQueryExecution(query).getResultSet().getRows();
        if (!rows.isEmpty()) {
            rows.remove(0);
        }
        ArrayList values = new ArrayList();
        rows.forEach(row -> values.add(((Datum)row.getData().get(0)).getVarCharValue()));
        logger.info("Titles: {}", values);
        AssertJUnit.assertEquals((String)"Wrong number of DB records found.", (int)1, (int)values.size());
        AssertJUnit.assertTrue((String)"Varchar not found: John Doe", (boolean)values.contains(TEST_DATATYPES_VARCHAR_VALUE));
    }

    @Test
    public void selectBooleanTypeTest() {
        logger.info("--------------------------------------");
        logger.info("Executing selectBooleanTypeTest");
        logger.info("--------------------------------------");
        String query = String.format("select boolean_type from %s.%s.%s;", this.lambdaFunctionName, INTEG_TEST_DATABASE_NAME, TEST_DATATYPES_TABLE_NAME);
        List rows = this.startQueryExecution(query).getResultSet().getRows();
        if (!rows.isEmpty()) {
            rows.remove(0);
        }
        ArrayList values = new ArrayList();
        rows.forEach(row -> values.add(Boolean.valueOf(((Datum)row.getData().get(0)).getVarCharValue())));
        logger.info("Titles: {}", values);
        AssertJUnit.assertEquals((String)"Wrong number of DB records found.", (int)1, (int)values.size());
        AssertJUnit.assertTrue((String)"Boolean not found: true", (boolean)values.contains(true));
    }

    @Test
    public void selectSmallintTypeTest() {
        logger.info("--------------------------------------");
        logger.info("Executing selectSmallintTypeTest");
        logger.info("--------------------------------------");
        String query = String.format("select smallint_type from %s.%s.%s;", this.lambdaFunctionName, INTEG_TEST_DATABASE_NAME, TEST_DATATYPES_TABLE_NAME);
        List rows = this.startQueryExecution(query).getResultSet().getRows();
        if (!rows.isEmpty()) {
            rows.remove(0);
        }
        ArrayList values = new ArrayList();
        rows.forEach(row -> values.add(Short.valueOf(((Datum)row.getData().get(0)).getVarCharValue().split("\\.")[0])));
        logger.info("Titles: {}", values);
        AssertJUnit.assertEquals((String)"Wrong number of DB records found.", (int)1, (int)values.size());
        AssertJUnit.assertTrue((String)"Smallint not found: -32768", (boolean)values.contains((short)Short.MIN_VALUE));
    }

    @Test
    public void selectBigintTypeTest() {
        logger.info("--------------------------------------");
        logger.info("Executing selectBigintTypeTest");
        logger.info("--------------------------------------");
        String query = String.format("select bigint_type from %s.%s.%s;", this.lambdaFunctionName, INTEG_TEST_DATABASE_NAME, TEST_DATATYPES_TABLE_NAME);
        List rows = this.startQueryExecution(query).getResultSet().getRows();
        if (!rows.isEmpty()) {
            rows.remove(0);
        }
        ArrayList values = new ArrayList();
        rows.forEach(row -> values.add(Long.valueOf(((Datum)row.getData().get(0)).getVarCharValue().split("\\.")[0])));
        AssertJUnit.assertEquals((String)"Wrong number of DB records found.", (int)1, (int)values.size());
        AssertJUnit.assertTrue((String)"Bigint not found: -9223372036854775808", (boolean)values.contains(Long.MIN_VALUE));
    }

    @Test
    public void selectFloat4TypeTest() {
        logger.info("--------------------------------------");
        logger.info("Executing selectFloat4TypeTest");
        logger.info("--------------------------------------");
        String query = String.format("select float4_type from %s.%s.%s;", this.lambdaFunctionName, INTEG_TEST_DATABASE_NAME, TEST_DATATYPES_TABLE_NAME);
        List rows = this.startQueryExecution(query).getResultSet().getRows();
        if (!rows.isEmpty()) {
            rows.remove(0);
        }
        ArrayList values = new ArrayList();
        rows.forEach(row -> values.add(Float.valueOf(((Datum)row.getData().get(0)).getVarCharValue())));
        AssertJUnit.assertEquals((String)"Wrong number of DB records found.", (int)1, (int)values.size());
        AssertJUnit.assertTrue((String)"Float4 not found: 1.0E-37", (boolean)values.contains(Float.valueOf(1.0E-37f)));
    }

    @Test
    public void selectFloat8TypeTest() {
        logger.info("--------------------------------------");
        logger.info("Executing selectFloat8TypeTest");
        logger.info("--------------------------------------");
        String query = String.format("select float8_type from %s.%s.%s;", this.lambdaFunctionName, INTEG_TEST_DATABASE_NAME, TEST_DATATYPES_TABLE_NAME);
        List rows = this.startQueryExecution(query).getResultSet().getRows();
        if (!rows.isEmpty()) {
            rows.remove(0);
        }
        ArrayList values = new ArrayList();
        rows.forEach(row -> values.add(Double.valueOf(((Datum)row.getData().get(0)).getVarCharValue())));
        AssertJUnit.assertEquals((String)"Wrong number of DB records found.", (int)1, (int)values.size());
        AssertJUnit.assertTrue((String)"Float8 not found: 1.0E-307", (boolean)values.contains(1.0E-307));
    }

    @Test
    public void selectDateTypeTest() {
        logger.info("--------------------------------------");
        logger.info("Executing selectDateTypeTest");
        logger.info("--------------------------------------");
        String query = String.format("select date_type from %s.%s.%s;", this.lambdaFunctionName, INTEG_TEST_DATABASE_NAME, TEST_DATATYPES_TABLE_NAME);
        List rows = this.startQueryExecution(query).getResultSet().getRows();
        if (!rows.isEmpty()) {
            rows.remove(0);
        }
        ArrayList values = new ArrayList();
        rows.forEach(row -> values.add(LocalDate.parse(((Datum)row.getData().get(0)).getVarCharValue())));
        AssertJUnit.assertEquals((String)"Wrong number of DB records found.", (int)1, (int)values.size());
        AssertJUnit.assertTrue((String)"Date not found: 2013-06-01", (boolean)values.contains(LocalDate.parse(TEST_DATATYPES_DATE_VALUE)));
    }

    @Test
    public void selectTimestampTypeTest() {
        logger.info("--------------------------------------");
        logger.info("Executing selectTimestampTypeTest");
        logger.info("--------------------------------------");
        String query = String.format("select timestamp_type from %s.%s.%s;", this.lambdaFunctionName, INTEG_TEST_DATABASE_NAME, TEST_DATATYPES_TABLE_NAME);
        List rows = this.startQueryExecution(query).getResultSet().getRows();
        if (!rows.isEmpty()) {
            rows.remove(0);
        }
        ArrayList values = new ArrayList();
        rows.forEach(row -> values.add(LocalDateTime.parse(((Datum)row.getData().get(0)).getVarCharValue().replace(' ', 'T'))));
        logger.info(((Datum)((Row)rows.get(0)).getData().get(0)).getVarCharValue());
        AssertJUnit.assertEquals((String)"Wrong number of DB records found.", (int)1, (int)values.size());
        AssertJUnit.assertTrue((String)"Date not found: 2016-06-22T19:10:25", (boolean)values.contains(LocalDateTime.parse(TEST_DATATYPES_TIMESTAMP_VALUE)));
    }

    @Test
    public void selectByteArrayTypeTest() {
        logger.info("--------------------------------------");
        logger.info("Executing selectByteArrayTypeTest");
        logger.info("--------------------------------------");
        String query = String.format("select byte_type from %s.%s.%s;", this.lambdaFunctionName, INTEG_TEST_DATABASE_NAME, TEST_DATATYPES_TABLE_NAME);
        List rows = this.startQueryExecution(query).getResultSet().getRows();
        if (!rows.isEmpty()) {
            rows.remove(0);
        }
        ArrayList values = new ArrayList();
        rows.forEach(row -> values.add(((Datum)row.getData().get(0)).getVarCharValue()));
        Datum actual = (Datum)((Row)rows.get(0)).getData().get(0);
        Datum expected = new Datum();
        expected.setVarCharValue("deadbeef");
        logger.info(((Datum)((Row)rows.get(0)).getData().get(0)).getVarCharValue());
        AssertJUnit.assertEquals((String)"Wrong number of DB records found.", (int)1, (int)values.size());
        String bytestring = actual.getVarCharValue().replace(" ", "");
        AssertJUnit.assertEquals((String)("Byte[] not found: " + Arrays.toString(TEST_DATATYPES_BYTE_ARRAY_VALUE)), (String)expected.getVarCharValue(), (String)bytestring);
    }

    @Test
    public void selectVarcharListTypeTest() {
        logger.info("--------------------------------------");
        logger.info("Executing selectVarcharListTypeTest");
        logger.info("--------------------------------------");
        String query = String.format("select textarray_type from %s.%s.%s;", this.lambdaFunctionName, INTEG_TEST_DATABASE_NAME, TEST_DATATYPES_TABLE_NAME);
        List rows = this.startQueryExecution(query).getResultSet().getRows();
        if (!rows.isEmpty()) {
            rows.remove(0);
        }
        ArrayList values = new ArrayList();
        rows.forEach(row -> values.add(((Datum)row.getData().get(0)).getVarCharValue()));
        Datum actual = (Datum)((Row)rows.get(0)).getData().get(0);
        Datum expected = new Datum();
        expected.setVarCharValue(TEST_DATATYPES_VARCHAR_ARRAY_VALUE);
        logger.info(((Datum)((Row)rows.get(0)).getData().get(0)).getVarCharValue());
        AssertJUnit.assertEquals((String)"Wrong number of DB records found.", (int)1, (int)values.size());
        AssertJUnit.assertEquals((String)"List not found: [(408)-589-5846, (408)-589-5555]", (Object)expected, (Object)actual);
    }

    @Test
    public void selectNullValueTest() {
        logger.info("--------------------------------------");
        logger.info("Executing selectNullValueTest");
        logger.info("--------------------------------------");
        String query = String.format("select int_type from %s.%s.%s;", this.lambdaFunctionName, INTEG_TEST_DATABASE_NAME, TEST_NULL_TABLE_NAME);
        List rows = this.startQueryExecution(query).getResultSet().getRows();
        if (!rows.isEmpty()) {
            rows.remove(0);
        }
        Datum actual = (Datum)((Row)rows.get(0)).getData().get(0);
        AssertJUnit.assertNull((String)("Value not 'null'. Received: " + actual.getVarCharValue()), (Object)actual.getVarCharValue());
    }

    @Test
    public void selectEmptyTableTest() {
        logger.info("--------------------------------------");
        logger.info("Executing selectEmptyTableTest");
        logger.info("--------------------------------------");
        String query = String.format("select int_type from %s.%s.%s;", this.lambdaFunctionName, INTEG_TEST_DATABASE_NAME, TEST_EMPTY_TABLE_NAME);
        List rows = this.startQueryExecution(query).getResultSet().getRows();
        if (!rows.isEmpty()) {
            rows.remove(0);
        }
        AssertJUnit.assertTrue((String)("Rows should be empty: " + rows.toString()), (boolean)rows.isEmpty());
    }
}

