/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.integ.clients;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClientBuilder;
import com.amazonaws.services.cloudformation.model.Capability;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsResult;
import com.amazonaws.services.cloudformation.model.StackEvent;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.internal.collections.Pair;
import software.amazon.awscdk.core.App;
import software.amazon.awscdk.core.Stack;

public class CloudFormationClient {
    private static final Logger logger = LoggerFactory.getLogger(CloudFormationClient.class);
    private static final String CF_CREATE_RESOURCE_IN_PROGRESS_STATUS = "CREATE_IN_PROGRESS";
    private static final String CF_CREATE_RESOURCE_FAILED_STATUS = "CREATE_FAILED";
    private static final long sleepTimeMillis = 5000L;
    private final String stackName;
    private final String stackTemplate;
    private final AmazonCloudFormation cloudFormationClient;

    public CloudFormationClient(Pair<App, Stack> stackPair) {
        this((App)stackPair.first(), (Stack)stackPair.second());
    }

    public CloudFormationClient(App theApp, Stack theStack) {
        this.stackName = theStack.getStackName();
        ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, true);
        this.stackTemplate = objectMapper.valueToTree(theApp.synth().getStackArtifact(theStack.getArtifactId()).getTemplate()).toPrettyString();
        this.cloudFormationClient = AmazonCloudFormationClientBuilder.defaultClient();
    }

    public void createStack() {
        logger.info("------------------------------------------------------");
        logger.info("Create CloudFormation stack: {}", (Object)this.stackName);
        logger.info("------------------------------------------------------");
        CreateStackRequest createStackRequest = new CreateStackRequest().withStackName(this.stackName).withTemplateBody(this.stackTemplate).withDisableRollback(Boolean.valueOf(true)).withCapabilities(new Capability[]{Capability.CAPABILITY_NAMED_IAM});
        this.processCreateStackRequest(createStackRequest);
    }

    private void processCreateStackRequest(CreateStackRequest createStackRequest) throws RuntimeException {
        String resourceStatus;
        DescribeStackEventsResult describeStackEventsResult;
        CreateStackResult result = this.cloudFormationClient.createStack(createStackRequest);
        logger.info("Stack ID: {}", (Object)result.getStackId());
        DescribeStackEventsRequest describeStackEventsRequest = new DescribeStackEventsRequest().withStackName(createStackRequest.getStackName());
        while (true) {
            describeStackEventsResult = this.cloudFormationClient.describeStackEvents(describeStackEventsRequest);
            StackEvent event = (StackEvent)describeStackEventsResult.getStackEvents().get(0);
            String resourceId = event.getLogicalResourceId();
            resourceStatus = event.getResourceStatus();
            logger.info("Resource Id: {}, Resource status: {}", (Object)resourceId, (Object)resourceStatus);
            if (resourceId.equals(event.getStackName()) && !resourceStatus.equals(CF_CREATE_RESOURCE_IN_PROGRESS_STATUS)) break;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread.sleep interrupted: " + e.getMessage(), e);
            }
        }
        if (resourceStatus.equals(CF_CREATE_RESOURCE_FAILED_STATUS)) {
            throw new RuntimeException(this.getCloudFormationErrorReasons(describeStackEventsResult.getStackEvents()));
        }
    }

    private String getCloudFormationErrorReasons(List<StackEvent> stackEvents) {
        StringBuilder errorMessageBuilder = new StringBuilder("CloudFormation stack creation failed due to the following reason(s):\n");
        stackEvents.forEach(stackEvent -> {
            if (stackEvent.getResourceStatus().equals(CF_CREATE_RESOURCE_FAILED_STATUS)) {
                String errorMessage = String.format("Resource: %s, Reason: %s\n", stackEvent.getLogicalResourceId(), stackEvent.getResourceStatusReason());
                errorMessageBuilder.append(errorMessage);
            }
        });
        return errorMessageBuilder.toString();
    }

    public void deleteStack() {
        logger.info("------------------------------------------------------");
        logger.info("Delete CloudFormation stack: {}", (Object)this.stackName);
        logger.info("------------------------------------------------------");
        try {
            DeleteStackRequest request = new DeleteStackRequest().withStackName(this.stackName);
            this.cloudFormationClient.deleteStack(request);
        }
        catch (Exception e) {
            logger.error("Something went wrong... Manual resource cleanup may be needed!!!", (Throwable)e);
        }
        finally {
            this.cloudFormationClient.shutdown();
        }
    }
}

