/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.integ.data;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class TestConfig {
    private static final String TEST_CONFIG_FILE_NAME = "etc/test-config.json";
    private final Map<String, Object> config = this.setUpTestConfig();

    private Map<String, Object> setUpTestConfig() throws RuntimeException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            return (Map)objectMapper.readValue(new File(TEST_CONFIG_FILE_NAME), HashMap.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse test-config.json: " + e.getMessage(), e);
        }
    }

    public Optional<Object> getItem(String attribute) {
        return Optional.ofNullable(this.config.get(attribute));
    }

    public Optional<String> getStringItem(String attribute) throws RuntimeException {
        Object item = this.getItem(attribute).orElseThrow(() -> new RuntimeException(attribute + " does not exist test-config.json file."));
        if (!(item instanceof String) || ((String)item).isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((String)item);
    }

    public Optional<Map<String, Object>> getMap(String attribute) throws RuntimeException {
        Object item = this.getItem(attribute).orElseThrow(() -> new RuntimeException(attribute + " does not exist test-config.json file."));
        if (!(item instanceof Map) || ((Map)item).isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Map)item);
    }

    public Optional<Map<String, String>> getStringMap(String attribute) throws RuntimeException {
        HashMap mapOfStrings = new HashMap();
        Object item = this.getItem(attribute).orElseThrow(() -> new RuntimeException(attribute + " does not exist test-config.json file."));
        if (item instanceof Map) {
            ((Map)item).forEach((key, value) -> {
                if (key instanceof String && value instanceof String) {
                    mapOfStrings.put((String)key, (String)value);
                }
            });
        }
        return mapOfStrings.isEmpty() ? Optional.empty() : Optional.of(mapOfStrings);
    }
}

